% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariates.R
\name{calc_tri}
\alias{calc_tri}
\title{Calculate toxic release covariates}
\usage{
calc_tri(
  from = NULL,
  locs,
  locs_id = "site_id",
  radius = c(1000L, 10000L, 50000L),
  geom = FALSE,
  ...
)
}
\arguments{
\item{from}{SpatVector(1). Output of \code{process_tri()}.}

\item{locs}{sf/SpatVector. Locations where TRI variables are calculated.}

\item{locs_id}{character(1). Unique site identifier column name.
Default is \code{"site_id"}.}

\item{radius}{Circular buffer radius.
Default is \code{c(1000, 10000, 50000)} (meters)}

\item{geom}{logical(1). Should the function return a \code{SpatVector}?
Default is \code{FALSE}. The coordinate reference system of the \code{SpatVector} is
that of \code{from.}}

\item{...}{Placeholders.}
}
\value{
a data.frame or SpatVector object
}
\description{
Extract toxic release values at point locations. Returns a \code{data.frame}
object containing \code{locs_id} and variables for each chemical in
\code{from}.
}
\note{
U.S. context.
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
loc <- data.frame(id = "001", lon = -78.90, lat = 35.97)
calc_tri(
  from = tri, # derived from process_tri() example
  locs = loc,
  locs_id = "id",
  radius = c(1e3L, 1e4L, 5e4L)
)
}
}
\seealso{
\code{\link{calc_sedc}}, \code{\link{process_tri}}
}
\author{
Insang Song, Mariana Kassien
}
