% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/replace.R
\docType{methods}
\name{replace_threshold}
\alias{replace_threshold}
\alias{replace_threshold-method}
\alias{replace_threshold,numeric,numeric,function-method}
\alias{replace_threshold,ANY,missing,function-method}
\alias{replace_threshold,numeric,numeric,numeric-method}
\alias{replace_threshold,ANY,missing,numeric-method}
\title{Replace Values Below a Given Threshold}
\usage{
replace_threshold(x, y, threshold, ...)

\S4method{replace_threshold}{numeric,numeric,`function`}(x, y, threshold, value = 0, ...)

\S4method{replace_threshold}{ANY,missing,`function`}(x, threshold, value = 0, ...)

\S4method{replace_threshold}{numeric,numeric,numeric}(x, y, threshold, value = 0, ...)

\S4method{replace_threshold}{ANY,missing,numeric}(x, threshold, value = 0, ...)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{threshold}{A \code{\link{numeric}} value or a \code{\link{function}} that takes a \code{numeric}
vector as argument and returns a single \code{numeric} value.}

\item{...}{Extra parameters to be passed to \code{threshold}.}

\item{value}{A \code{\link{numeric}} value to replace values below \code{threshold}.}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Replace Values Below a Given Threshold
}
\seealso{
Other replacement methods: 
\code{\link{replace_negative}()}
}
\author{
N. Frerebeau
}
\concept{replacement methods}
