% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/baseline.R
\docType{methods}
\name{baseline_rubberband}
\alias{baseline_rubberband}
\alias{baseline_rubberband-method}
\alias{baseline_rubberband,numeric,numeric-method}
\alias{baseline_rubberband,ANY,missing-method}
\title{Rubberband Baseline Estimation}
\usage{
baseline_rubberband(x, y, ...)

\S4method{baseline_rubberband}{numeric,numeric}(x, y, noise = 0, spline = TRUE, ...)

\S4method{baseline_rubberband}{ANY,missing}(x, noise = 0, spline = TRUE, ...)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Extra arguments to be passed to \code{\link[stats:smooth.spline]{stats::smooth.spline()}}.}

\item{noise}{A length-one \code{\link{numeric}} vector giving the noise level.
Only used if \code{method} is "\code{rubberband}".}

\item{spline}{A \code{\link{logical}} scalar: should spline interpolation through the
support points be used instead of linear interpolation?
Only used if \code{method} is "\code{rubberband}".}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Rubberband Baseline Estimation
}
\details{
A convex envelope of the spectrum is determined and the
baseline is estimated as the part of the convex envelope lying below the
spectrum. Note that the rubber band does not enter the concave regions
(if any) of the spectrum.
}
\note{
\code{baseline_rubberband()} is slightly modified from C. Beleites'
\code{\link[hyperSpec:spc-rubberband]{hyperSpec::spc.rubberband()}}.
}
\examples{
## gamma-ray spectrometry
data("BEGe")

## Subset from 2.75 to 200 keV
BEGe <- signal_select(BEGe, from = 3, to = 200)

## Plot spectrum
plot(BEGe, type = "l", xlab = "Energy (keV)", ylab = "Count")

## Rubberband baseline
baseline <- baseline_rubberband(BEGe)

plot(BEGe, type = "l", xlab = "Energy (keV)", ylab = "Count")
lines(baseline, type = "l", col = "red")
}
\seealso{
\code{\link[=signal_correct]{signal_correct()}}

Other baseline estimation methods: 
\code{\link{baseline_linear}()},
\code{\link{baseline_peakfilling}()},
\code{\link{baseline_polynomial}()},
\code{\link{baseline_rollingball}()},
\code{\link{baseline_snip}()}
}
\author{
N. Frerebeau
}
\concept{baseline estimation methods}
