% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareVGA.R
\name{unmakeVGAGraph}
\alias{unmakeVGAGraph}
\title{Unmake the graph in a PointMap}
\usage{
unmakeVGAGraph(pointMap, removeLinks = FALSE, verbose = FALSE)
}
\arguments{
\item{pointMap}{The input PointMap}

\item{removeLinks}{Also remove the links}

\item{verbose}{Optional. Show more information of the process.}
}
\value{
None
}
\description{
Unmake the graph in a PointMap
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "simple",
    "simple_interior.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeMap <- as(sfMap[, vector()], "ShapeMap")
pointMap <- makeVGAPointMap(
  sfMap,
  gridSize = 0.5,
  fillX = 3.01,
  fillY = 6.7,
  maxVisibility = NA,
  boundaryGraph = FALSE,
  verbose = FALSE
)
unmakeVGAGraph(
  pointMap = pointMap,
  removeLinks = FALSE
)
}
