% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbow_point.R
\name{elbow_point}
\alias{elbow_point}
\title{Determine the elbow point on a curve}
\usage{
elbow_point(x, y)
}
\arguments{
\item{x}{vector of x coordinates of points on the curve}

\item{y}{vector of y coordinates of points on the curve}
}
\value{
indicate the optimal k value determined by
the elbow point point.
}
\description{
Given a list of x, y coordinates on a curve,
function determines the elbow point of the curve.
}
\details{
highlight the maximum curvature to identify the
elbow point (credit: 'github.com/agentlans')
}
\examples{

# Generate some curve
x <- runif(100, min=-2, max=3)
y <- -exp(-x) * (1+rnorm(100)/3)
plot(x, y)
#Plot elbow points
abline(v=elbow_point(x,y)$y, col="blue", pch=20, cex=3)

}
