% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyword_cloud.R
\name{keyword_cloud}
\alias{keyword_cloud}
\title{Draw word cloud for grouped keywords}
\usage{
keyword_cloud(tibble_graph, group_no = NULL, top = 50, max_size = 20)
}
\arguments{
\item{tibble_graph}{A \code{tbl_graph} output by \code{\link[akc]{keyword_group}}.}

\item{group_no}{If one wants to visualize a specific group, gives the group number.
Default uses \code{NULL},which returns all the groups.}

\item{top}{How many top keywords (by frequency) should be plot? Default uses 50.}

\item{max_size}{Size of largest keyword.Default uses 20.}
}
\description{
This function should be used to plot the object exported by
\code{\link[akc]{keyword_group}}. It could draw a robust word cloud of keywords.
}
\details{
In the output graph, the size of keywords is proportional to the keyword
frequency, keywords in different colours belong to different group. For advanced
usage of word cloud, use \pkg{ggwordcloud} directly with the grouped keywords
yielded by \code{\link[akc]{keyword_group}}.
}
\examples{

library(dplyr)
library(akc)

bibli_data_table \%>\%
  keyword_clean(id = "id",keyword = "keyword") \%>\%
  keyword_group(id = "id",keyword = "keyword") -> grouped_keyword

grouped_keyword \%>\%
  keyword_cloud()

grouped_keyword \%>\%
  keyword_cloud(group_no = 1)
}
\seealso{
\code{\link[akc]{keyword_group}},
\code{\link[ggwordcloud]{geom_text_wordcloud_area}}
}
