% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_fct.R
\name{create_iota2_mean_object}
\alias{create_iota2_mean_object}
\title{Create an iota2 object}
\usage{
create_iota2_mean_object(
  iota2_list,
  free_aem = FALSE,
  call = "aifeducation::te_classifier_neuralnet",
  original_cat_labels
)
}
\arguments{
\item{iota2_list}{\code{list} of objects of class \code{iotarelr_iota2}.}

\item{free_aem}{\code{bool} \code{TRUE} if the iota2 objects are estimated
without forcing the assumption of weak superiority.}

\item{call}{\code{string} characterizing the source of estimation. That is, the
function within the object was estimated.}

\item{original_cat_labels}{\code{vector} containing the original labels of each
category.}
}
\value{
Returns an object of class \code{iotarelr_iota2} which is the mean
iota2 object.
}
\description{
Function creates an object of class \code{iotarelr_iota2} which can be used
with the package iotarelr. This function is for internal use only.
}
\seealso{
Other Auxiliary Functions: 
\code{\link{array_to_matrix}()},
\code{\link{calc_standard_classification_measures}()},
\code{\link{check_embedding_models}()},
\code{\link{create_synthetic_units}()},
\code{\link{generate_id}()},
\code{\link{get_coder_metrics}()},
\code{\link{get_folds}()},
\code{\link{get_n_chunks}()},
\code{\link{get_stratified_train_test_split}()},
\code{\link{get_synthetic_cases}()},
\code{\link{get_train_test_split}()},
\code{\link{matrix_to_array_c}()},
\code{\link{split_labeled_unlabeled}()},
\code{\link{summarize_tracked_sustainability}()},
\code{\link{to_categorical_c}()}
}
\concept{Auxiliary Functions}
\keyword{internal}
