/*
 * Decompiled with CFR 0.152.
 */
package org.ddahl.aibd.model.lineargaussian;

import java.io.Serializable;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.FastMath;
import org.ddahl.aibd.FeatureAllocation;
import org.ddahl.aibd.model.lineargaussian.LikelihoodComponents;
import org.ddahl.aibd.model.lineargaussian.LinearGaussianLatentFeatureModel$;
import org.ddahl.matrix$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0005\tMa\u0001B\u001e=\u0001\u001dC\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t;\u0002\u0011\t\u0011)A\u0005\u001f\"Aa\f\u0001B\u0001B\u0003%q\n\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003a\u0011!\u0019\u0007A!A!\u0002\u0013\u0001\u0007\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u000b\u0015\u0004A\u0011\u00024\t\u000f=\u0004!\u0019!C\u0001a\"1A\u000f\u0001Q\u0001\nEDq!\u001e\u0001C\u0002\u0013\u0005\u0001\u000f\u0003\u0004w\u0001\u0001\u0006I!\u001d\u0005\u0006o\u0002!\t\u0001\u001f\u0005\u0006s\u0002!\t\u0001\u001f\u0005\u0006u\u0002!\t\u0001\u001f\u0005\u0006w\u0002!\t\u0001\u001f\u0005\by\u0002\u0011\r\u0011\"\u0003y\u0011\u0019i\b\u0001)A\u0005A\"9a\u0010\u0001b\u0001\n\u0013A\bBB@\u0001A\u0003%\u0001\r\u0003\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0003y\u0011\u001d\t\u0019\u0001\u0001Q\u0001\n\u0001D\u0001\"!\u0002\u0001\u0005\u0004%I\u0001\u001f\u0005\b\u0003\u000f\u0001\u0001\u0015!\u0003a\u0011!\tI\u0001\u0001b\u0001\n\u0013A\bbBA\u0006\u0001\u0001\u0006I\u0001\u0019\u0005\t\u0003\u001b\u0001!\u0019!C\u0005q\"9\u0011q\u0002\u0001!\u0002\u0013\u0001\u0007bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\t\t\u0003\u0001C\u0001\u0003GAq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u0002*\u0001!\t!a\u000e\t\u000f\u0005%\u0002\u0001\"\u0001\u0002F!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0003bBA\u0015\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003S\u0001A\u0011AA-\u0011\u001d\tI\u0003\u0001C\u0001\u0003?Bq!!\u000b\u0001\t\u0003\ti\u0007C\u0004\u0002v\u0001!\t!a\u001e\t\u000f\u0005U\u0004\u0001\"\u0001\u0002|!9\u0011Q\u000f\u0001\u0005\u0002\u0005}\u0004bBA;\u0001\u0011\u0005\u0011q\u0011\u0005\b\u0003k\u0002A\u0011AAF\u0011\u001d\t)\b\u0001C\u0001\u0003\u001fCq!!\u001e\u0001\t\u0003\t\u0019\nC\u0004\u0002\u0018\u0002!I!!'\t\u000f\u0005]\u0006\u0001\"\u0001\u0002:\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0007bBAf\u0001\u0011\u0005\u0011QZ\u0004\b\u0003+d\u0004\u0012AAl\r\u0019YD\b#\u0001\u0002Z\"1Qm\rC\u0001\u00037Dq!!84\t\u0003\ty\u000eC\u0004\u0002hN\"\t!!;\t\u000f\u0005E8\u0007\"\u0001\u0002t\"9\u0011Q\\\u001a\u0005\u0002\u0005m\bbBAtg\u0011\u0005!1\u0001\u0005\b\u0003c\u001cD\u0011\u0001B\u0006\u0005\u0001b\u0015N\\3be\u001e\u000bWo]:jC:d\u0015\r^3oi\u001a+\u0017\r^;sK6{G-\u001a7\u000b\u0005ur\u0014A\u00047j]\u0016\f'oZ1vgNL\u0017M\u001c\u0006\u0003\u007f\u0001\u000bQ!\\8eK2T!!\u0011\"\u0002\t\u0005L'\r\u001a\u0006\u0003\u0007\u0012\u000bQ\u0001\u001a3bQ2T\u0011!R\u0001\u0004_J<7\u0001A\n\u0003\u0001!\u0003\"!\u0013'\u000e\u0003)S\u0011aS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b*\u0013a!\u00118z%\u00164\u0017!\u0001-\u0011\u0005ASfBA)Y\u001d\t\u0011vK\u0004\u0002T-6\tAK\u0003\u0002V\r\u00061AH]8pizJ\u0011!R\u0005\u0003\u0007\u0012K!!\u0017\"\u0002\r5\fGO]5y\u0013\tYFL\u0001\u0004NCR\u0014\u0018\u000e\u001f\u0006\u00033\n\u000b!\u0001\u0017;\u0002\u0007a#\b,\u0001\u0005ue\u0006\u001cW\r\u0017;Y!\tI\u0015-\u0003\u0002c\u0015\n1Ai\\;cY\u0016\f!\u0002\u001d:fG&\u001c\u0018n\u001c8Y\u0003)\u0001(/Z2jg&|gnV\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f\u001dL'n\u001b7n]B\u0011\u0001\u000eA\u0007\u0002y!)aj\u0002a\u0001\u001f\")Ql\u0002a\u0001\u001f\")al\u0002a\u0001\u001f\")ql\u0002a\u0001A\")1m\u0002a\u0001A\")Am\u0002a\u0001A\u0006\ta*F\u0001r!\tI%/\u0003\u0002t\u0015\n\u0019\u0011J\u001c;\u0002\u00059\u0003\u0013!\u0001#\u0002\u0005\u0011\u0003\u0013AE:uC:$\u0017M\u001d3EKZL\u0017\r^5p]b+\u0012\u0001Y\u0001\u0013gR\fg\u000eZ1sI\u0012+g/[1uS>tw+A\u0005wCJL\u0017M\\2f1\u0006Ia/\u0019:jC:\u001cWmV\u0001\u0006\t\"\fGNZ\u0001\u0007\t\"\fGN\u001a\u0011\u0002\u000b\r|gn\u001d;\u0002\r\r|gn\u001d;!\u0003]!\u0005.\u00197g)&lWm\u001d'pOB\u0013XmY5tS>t\u0007,\u0001\rEQ\u0006dg\rV5nKNdun\u001a)sK\u000eL7/[8o1\u0002\nq\u0003\u00125bY\u001a$\u0016.\\3t\u0019><\u0007K]3dSNLwN\\,\u00021\u0011C\u0017\r\u001c4US6,7\u000fT8h!J,7-[:j_:<\u0006%\u0001\biC24\u0007K]3dSNLwN\u001c-\u0002\u001f!\fGN\u001a)sK\u000eL7/[8o1\u0002\n\u0011C]1uS>|e\r\u0015:fG&\u001c\u0018n\u001c8t\u0003I\u0011\u0018\r^5p\u001f\u001a\u0004&/Z2jg&|gn\u001d\u0011\u0002!U\u0004H-\u0019;f!J,7-[:j_:\u001cH#B4\u0002\u0016\u0005]\u0001\"B2\u001d\u0001\u0004\u0001\u0007\"\u00023\u001d\u0001\u0004\u0001\u0017\u0001G;qI\u0006$Xm\u0015;b]\u0012\f'\u000f\u001a#fm&\fG/[8ogR)q-!\b\u0002 !)q/\ba\u0001A\")\u00110\ba\u0001A\u0006yQ\u000f\u001d3bi\u00164\u0016M]5b]\u000e,7\u000fF\u0003h\u0003K\t9\u0003C\u0003{=\u0001\u0007\u0001\rC\u0003|=\u0001\u0007\u0001-A\u0007m_\u001ed\u0015n[3mS\"|w\u000e\u001a\u000b\u0004A\u00065\u0002bBA\u0018?\u0001\u0007\u0011\u0011G\u0001\u0003Y\u000e\u00042\u0001[A\u001a\u0013\r\t)\u0004\u0010\u0002\u0015\u0019&\\W\r\\5i_>$7i\\7q_:,g\u000e^:\u0015\t\u0005e\u0012q\b\t\u0005\u0013\u0006m\u0002-C\u0002\u0002>)\u0013Q!\u0011:sCfDq!!\u0011!\u0001\u0004\t\u0019%A\u0002mGN\u0004R!SA\u001e\u0003c!2\u0001YA$\u0011\u0019\tI%\ta\u0001\u001f\u0006\t!\f\u0006\u0003\u0002:\u00055\u0003bBA(E\u0001\u0007\u0011\u0011K\u0001\u00035N\u0004B!SA\u001e\u001fR\u0019\u0001-!\u0016\t\u000f\u0005%3\u00051\u0001\u0002XA)\u0011*a\u000f\u0002:Q!\u0011\u0011HA.\u0011\u001d\ty\u0005\na\u0001\u0003;\u0002R!SA\u001e\u0003/\"2\u0001YA1\u0011\u001d\t\u0019'\na\u0001\u0003K\n\u0011CZ3biV\u0014X-\u00117m_\u000e\fG/[8o!\u0011\t9'!\u001b\u000e\u0003\u0001K1!a\u001bA\u0005E1U-\u0019;ve\u0016\fE\u000e\\8dCRLwN\u001c\u000b\u0005\u0003s\ty\u0007C\u0004\u0002r\u0019\u0002\r!a\u001d\u0002%\u0019,\u0017\r^;sK\u0006cGn\\2bi&|gn\u001d\t\u0006\u0013\u0006m\u0012QM\u0001\u001cG>l\u0007/\u001e;f\u0019&\\W\r\\5i_>$7i\\7q_:,g\u000e^:\u0015\t\u0005E\u0012\u0011\u0010\u0005\u0007\u0003\u0013:\u0003\u0019A(\u0015\t\u0005E\u0012Q\u0010\u0005\b\u0003\u0013B\u0003\u0019AA,)\u0011\t\t$!!\t\u000f\u0005%\u0013\u00061\u0001\u0002\u0004B)\u0011*a\u000f\u0002\u0006B!\u0011*a\u000fr)\u0011\t\t$!#\t\u000f\u0005\r$\u00061\u0001\u0002fQ!\u00111IAG\u0011\u001d\tye\u000ba\u0001\u0003#\"B!a\u0011\u0002\u0012\"9\u0011q\n\u0017A\u0002\u0005uC\u0003BA\"\u0003+Cq!!\u001d.\u0001\u0004\t\u0019(\u0001\u0004va\u0012\fG/\u001a\u000b\u000b\u00037\u000b\t+!*\u0002*\u00065\u0006#B%\u0002\u001e>\u0003\u0017bAAP\u0015\n1A+\u001e9mKJBa!a)/\u0001\u0004y\u0015!A'\t\r\u0005\u001df\u00061\u0001a\u0003\u0005!\u0007bBAV]\u0001\u0007\u0011\u0011H\u0001\u0002u\"9\u0011q\u0016\u0018A\u0002\u0005E\u0016aA1eIB\u0019\u0011*a-\n\u0007\u0005U&JA\u0004C_>dW-\u00198\u0002+\u0011,\u0017\r\u001c7pG\u0006$XMR3biV\u0014Xm\u001d$peR1\u0011\u0011GA^\u0003\u007fCa!!00\u0001\u0004\t\u0018!A5\t\u000f\u0005=r\u00061\u0001\u00022\u0005\u0019\u0012\r\u001c7pG\u0006$XMR3biV\u0014Xm\u001d$peRA\u0011\u0011GAc\u0003\u000f\fI\r\u0003\u0004\u0002>B\u0002\r!\u001d\u0005\b\u0003_\u0001\u0004\u0019AA\u0019\u0011\u001d\tY\u000b\ra\u0001\u0003s\tQC]3bY2|7-\u0019;f\r\u0016\fG/\u001e:fg\u001a{'\u000f\u0006\u0005\u00022\u0005=\u0017\u0011[Aj\u0011\u0019\ti,\ra\u0001c\"9\u0011qF\u0019A\u0002\u0005E\u0002bBAVc\u0001\u0007\u0011\u0011H\u0001!\u0019&tW-\u0019:HCV\u001c8/[1o\u0019\u0006$XM\u001c;GK\u0006$XO]3N_\u0012,G\u000e\u0005\u0002igM\u00111\u0007\u0013\u000b\u0003\u0003/\fq\"^:j]\u001e\u0004&/Z2jg&|gn\u001d\u000b\bO\u0006\u0005\u00181]As\u0011\u0015qU\u00071\u0001P\u0011\u0015\u0019W\u00071\u0001a\u0011\u0015!W\u00071\u0001a\u0003])8/\u001b8h'R\fg\u000eZ1sI\u0012+g/[1uS>t7\u000fF\u0004h\u0003W\fi/a<\t\u000b93\u0004\u0019A(\t\u000b]4\u0004\u0019\u00011\t\u000be4\u0004\u0019\u00011\u0002\u001dU\u001c\u0018N\\4WCJL\u0017M\\2fgR9q-!>\u0002x\u0006e\b\"\u0002(8\u0001\u0004y\u0005\"\u0002>8\u0001\u0004\u0001\u0007\"B>8\u0001\u0004\u0001GcB4\u0002~\u0006}(\u0011\u0001\u0005\u0007\u001db\u0002\r!a\u0016\t\u000b\rD\u0004\u0019\u00011\t\u000b\u0011D\u0004\u0019\u00011\u0015\u000f\u001d\u0014)Aa\u0002\u0003\n!1a*\u000fa\u0001\u0003/BQa^\u001dA\u0002\u0001DQ!_\u001dA\u0002\u0001$ra\u001aB\u0007\u0005\u001f\u0011\t\u0002\u0003\u0004Ou\u0001\u0007\u0011q\u000b\u0005\u0006uj\u0002\r\u0001\u0019\u0005\u0006wj\u0002\r\u0001\u0019")
public class LinearGaussianLatentFeatureModel {
    private final RealMatrix X;
    private final RealMatrix Xt;
    private final RealMatrix XtX;
    private final double traceXtX;
    private final double precisionX;
    private final double precisionW;
    private final int N;
    private final int D;
    private final double Dhalf;
    private final double const;
    private final double DhalfTimesLogPrecisionX;
    private final double DhalfTimesLogPrecisionW;
    private final double halfPrecisionX;
    private final double ratioOfPrecisions;

    public static LinearGaussianLatentFeatureModel usingVariances(double[][] dArray, double d, double d2) {
        return LinearGaussianLatentFeatureModel$.MODULE$.usingVariances(dArray, d, d2);
    }

    public static LinearGaussianLatentFeatureModel usingStandardDeviations(double[][] dArray, double d, double d2) {
        return LinearGaussianLatentFeatureModel$.MODULE$.usingStandardDeviations(dArray, d, d2);
    }

    public static LinearGaussianLatentFeatureModel usingPrecisions(double[][] dArray, double d, double d2) {
        return LinearGaussianLatentFeatureModel$.MODULE$.usingPrecisions(dArray, d, d2);
    }

    public static LinearGaussianLatentFeatureModel usingVariances(RealMatrix realMatrix, double d, double d2) {
        return LinearGaussianLatentFeatureModel$.MODULE$.usingVariances(realMatrix, d, d2);
    }

    public static LinearGaussianLatentFeatureModel usingStandardDeviations(RealMatrix realMatrix, double d, double d2) {
        return LinearGaussianLatentFeatureModel$.MODULE$.usingStandardDeviations(realMatrix, d, d2);
    }

    public static LinearGaussianLatentFeatureModel usingPrecisions(RealMatrix realMatrix, double d, double d2) {
        return LinearGaussianLatentFeatureModel$.MODULE$.usingPrecisions(realMatrix, d, d2);
    }

    public int N() {
        return this.N;
    }

    public int D() {
        return this.D;
    }

    public double standardDeviationX() {
        return 1.0 / FastMath.sqrt((double)this.precisionX);
    }

    public double standardDeviationW() {
        return 1.0 / FastMath.sqrt((double)this.precisionW);
    }

    public double varianceX() {
        return 1.0 / this.precisionX;
    }

    public double varianceW() {
        return 1.0 / this.precisionW;
    }

    private double Dhalf() {
        return this.Dhalf;
    }

    private double const() {
        return this.const;
    }

    private double DhalfTimesLogPrecisionX() {
        return this.DhalfTimesLogPrecisionX;
    }

    private double DhalfTimesLogPrecisionW() {
        return this.DhalfTimesLogPrecisionW;
    }

    private double halfPrecisionX() {
        return this.halfPrecisionX;
    }

    private double ratioOfPrecisions() {
        return this.ratioOfPrecisions;
    }

    public LinearGaussianLatentFeatureModel updatePrecisions(double precisionX, double precisionW) {
        return new LinearGaussianLatentFeatureModel(this.X, this.Xt, this.XtX, this.traceXtX, precisionX, precisionW);
    }

    public LinearGaussianLatentFeatureModel updateStandardDeviations(double standardDeviationX, double standardDeviationW) {
        return new LinearGaussianLatentFeatureModel(this.X, this.Xt, this.XtX, this.traceXtX, 1.0 / (standardDeviationX * standardDeviationX), 1.0 / (standardDeviationW * standardDeviationW));
    }

    public LinearGaussianLatentFeatureModel updateVariances(double varianceX, double varianceW) {
        return new LinearGaussianLatentFeatureModel(this.X, this.Xt, this.XtX, this.traceXtX, 1.0 / varianceX, 1.0 / varianceW);
    }

    public double logLikelihood(LikelihoodComponents lc) {
        return lc.K() == 0 ? this.const() + (double)this.N() * this.DhalfTimesLogPrecisionX() : this.const() + (double)(this.N() - lc.K()) * this.DhalfTimesLogPrecisionX() + (double)lc.K() * this.DhalfTimesLogPrecisionW() - this.Dhalf() * FastMath.log((double)lc.d()) + this.halfPrecisionX() * matrix$.MODULE$.trace(matrix$.MODULE$.realMatrix2RichMatrix(matrix$.MODULE$.realMatrix2RichMatrix(matrix$.MODULE$.realMatrix2RichMatrix(matrix$.MODULE$.realMatrix2RichMatrix(this.Xt).$times(lc.Z())).$times(lc.M())).$times(lc.Zt())).$times(this.X));
    }

    public double[] logLikelihood(LikelihoodComponents[] lcs) {
        return (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])lcs), (Function1 & Serializable)lc -> BoxesRunTime.boxToDouble((double)this.logLikelihood(lc)), (ClassTag)ClassTag$.MODULE$.Double());
    }

    public double logLikelihood(RealMatrix Z) {
        return this.logLikelihood(this.computeLikelihoodComponents(Z));
    }

    public double[] logLikelihood(RealMatrix[] Zs) {
        return this.logLikelihood(this.computeLikelihoodComponents(Zs));
    }

    public double logLikelihood(double[][] Z) {
        return this.logLikelihood(this.computeLikelihoodComponents(Z));
    }

    public double[] logLikelihood(double[][][] Zs) {
        return this.logLikelihood(this.computeLikelihoodComponents(Zs));
    }

    public double logLikelihood(FeatureAllocation featureAllocation) {
        return this.logLikelihood(this.computeLikelihoodComponents(featureAllocation));
    }

    public double[] logLikelihood(FeatureAllocation[] featureAllocations) {
        return this.logLikelihood(this.computeLikelihoodComponents(featureAllocations));
    }

    public LikelihoodComponents computeLikelihoodComponents(RealMatrix Z) {
        LikelihoodComponents likelihoodComponents;
        if (Z == null) {
            likelihoodComponents = new LikelihoodComponents(null, null, null, 0.0);
        } else {
            CholeskyDecomposition choleskyDecomposition;
            if (matrix$.MODULE$.realMatrix2RichMatrix(Z).rows() != this.N()) {
                throw new IllegalArgumentException(new StringBuilder(50).append("Feature allocation has ").append(matrix$.MODULE$.realMatrix2RichMatrix(Z).rows()).append(" items, but ").append(this.N()).append(" were expected.").toString());
            }
            RealMatrix Zt = matrix$.MODULE$.realMatrix2RichMatrix(Z).t();
            RealMatrix W = matrix$.MODULE$.realMatrix2RichMatrix(matrix$.MODULE$.realMatrix2RichMatrix(Zt).$times(Z)).$plus(matrix$.MODULE$.diag((double[])Array$.MODULE$.fill(matrix$.MODULE$.realMatrix2RichMatrix(Z).cols(), (Function0)(JFunction0.mcD.sp & Serializable)() -> this.ratioOfPrecisions(), (ClassTag)ClassTag$.MODULE$.Double())));
            try {
                choleskyDecomposition = new CholeskyDecomposition(W);
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)matrix$.MODULE$.pretty(W, matrix$.MODULE$.pretty$default$2()));
                throw e;
            }
            CholeskyDecomposition chol = choleskyDecomposition;
            RealMatrix m = chol.getSolver().getInverse();
            double d = chol.getDeterminant();
            likelihoodComponents = new LikelihoodComponents(Z, Zt, m, d);
        }
        return likelihoodComponents;
    }

    public LikelihoodComponents computeLikelihoodComponents(double[][] Z) {
        return this.computeLikelihoodComponents(matrix$.MODULE$.wrap(Z));
    }

    public LikelihoodComponents computeLikelihoodComponents(int[][] Z) {
        return this.computeLikelihoodComponents((double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])Z), (Function1 & Serializable)x$1 -> (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(x$1), (Function1)(JFunction1.mcDI.sp & Serializable)x$2 -> x$2, (ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
    }

    public LikelihoodComponents computeLikelihoodComponents(FeatureAllocation featureAllocation) {
        return this.computeLikelihoodComponents(featureAllocation.matrix());
    }

    public LikelihoodComponents[] computeLikelihoodComponents(RealMatrix[] Zs) {
        return (LikelihoodComponents[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])Zs), (Function1 & Serializable)Z -> this.computeLikelihoodComponents((RealMatrix)Z), ClassTag$.MODULE$.apply(LikelihoodComponents.class));
    }

    public LikelihoodComponents[] computeLikelihoodComponents(double[][][] Zs) {
        return (LikelihoodComponents[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])Zs), (Function1 & Serializable)Z -> this.computeLikelihoodComponents((double[][])Z), ClassTag$.MODULE$.apply(LikelihoodComponents.class));
    }

    public LikelihoodComponents[] computeLikelihoodComponents(FeatureAllocation[] featureAllocations) {
        return (LikelihoodComponents[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])featureAllocations), (Function1 & Serializable)featureAllocation -> this.computeLikelihoodComponents((FeatureAllocation)featureAllocation), ClassTag$.MODULE$.apply(LikelihoodComponents.class));
    }

    private Tuple2<RealMatrix, Object> update(RealMatrix M, double d, double[] z, boolean add) {
        int sign = add ? 1 : -1;
        double zMz = matrix$.MODULE$.array2RichDoubleArray(matrix$.MODULE$.array2RichDoubleArray(z).$times(M)).$times(z);
        return new Tuple2((Object)matrix$.MODULE$.realMatrix2RichMatrix(M).$minus(matrix$.MODULE$.realMatrix2RichMatrix(matrix$.MODULE$.realMatrix2RichMatrix(matrix$.MODULE$.array2RichDoubleArray(matrix$.MODULE$.realMatrix2RichMatrix(M).$times(z)).$times$times(z)).$times(M)).$div(zMz + (double)sign)), (Object)BoxesRunTime.boxToDouble((double)(d * (1.0 + (double)sign * zMz))));
    }

    public LikelihoodComponents deallocateFeaturesFor(int i, LikelihoodComponents lc) {
        LikelihoodComponents likelihoodComponents;
        if (lc.Z() == null) {
            likelihoodComponents = lc;
        } else {
            RealMatrix Z = lc.Z().copy();
            double[] zOld = matrix$.MODULE$.realMatrix2RichMatrix(Z).apply(i, package$.MODULE$.$colon$colon());
            matrix$.MODULE$.realMatrix2RichMatrix(Z).update(i, package$.MODULE$.$colon$colon(), (double[])Array$.MODULE$.ofDim(lc.K(), (ClassTag)ClassTag$.MODULE$.Double()));
            Tuple2<RealMatrix, Object> tuple2 = this.update(lc.M(), lc.d(), zOld, false);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            RealMatrix m = (RealMatrix)tuple2._1();
            double d = tuple2._2$mcD$sp();
            Tuple2 tuple22 = new Tuple2((Object)m, (Object)BoxesRunTime.boxToDouble((double)d));
            Tuple2 tuple23 = tuple22;
            RealMatrix m2 = (RealMatrix)tuple23._1();
            double d2 = tuple23._2$mcD$sp();
            likelihoodComponents = new LikelihoodComponents(Z, matrix$.MODULE$.realMatrix2RichMatrix(Z).t(), m2, d2);
        }
        return likelihoodComponents;
    }

    public LikelihoodComponents allocateFeaturesFor(int i, LikelihoodComponents lc, double[] z) {
        LikelihoodComponents likelihoodComponents;
        if (lc.Z() == null) {
            likelihoodComponents = this.computeLikelihoodComponents(matrix$.MODULE$.wrap(z));
        } else {
            RealMatrix Z = lc.Z().copy();
            matrix$.MODULE$.realMatrix2RichMatrix(Z).update(i, package$.MODULE$.$colon$colon(), z);
            Tuple2<RealMatrix, Object> tuple2 = this.update(lc.M(), lc.d(), z, true);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            RealMatrix m = (RealMatrix)tuple2._1();
            double d = tuple2._2$mcD$sp();
            Tuple2 tuple22 = new Tuple2((Object)m, (Object)BoxesRunTime.boxToDouble((double)d));
            Tuple2 tuple23 = tuple22;
            RealMatrix m2 = (RealMatrix)tuple23._1();
            double d2 = tuple23._2$mcD$sp();
            likelihoodComponents = new LikelihoodComponents(Z, matrix$.MODULE$.realMatrix2RichMatrix(Z).t(), m2, d2);
        }
        return likelihoodComponents;
    }

    public LikelihoodComponents reallocateFeaturesFor(int i, LikelihoodComponents lc, double[] z) {
        LikelihoodComponents likelihoodComponents;
        if (lc.Z() == null) {
            likelihoodComponents = this.computeLikelihoodComponents(matrix$.MODULE$.wrap(z));
        } else {
            LikelihoodComponents newLC = this.deallocateFeaturesFor(i, lc);
            matrix$.MODULE$.realMatrix2RichMatrix(newLC.Z()).update(i, package$.MODULE$.$colon$colon(), z);
            Tuple2<RealMatrix, Object> tuple2 = this.update(newLC.M(), newLC.d(), z, true);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            RealMatrix m = (RealMatrix)tuple2._1();
            double d = tuple2._2$mcD$sp();
            Tuple2 tuple22 = new Tuple2((Object)m, (Object)BoxesRunTime.boxToDouble((double)d));
            Tuple2 tuple23 = tuple22;
            RealMatrix m2 = (RealMatrix)tuple23._1();
            double d2 = tuple23._2$mcD$sp();
            likelihoodComponents = new LikelihoodComponents(newLC.Z(), matrix$.MODULE$.realMatrix2RichMatrix(newLC.Z()).t(), m2, d2);
        }
        return likelihoodComponents;
    }

    public LinearGaussianLatentFeatureModel(RealMatrix X, RealMatrix Xt, RealMatrix XtX, double traceXtX, double precisionX, double precisionW) {
        this.X = X;
        this.Xt = Xt;
        this.XtX = XtX;
        this.traceXtX = traceXtX;
        this.precisionX = precisionX;
        this.precisionW = precisionW;
        this.N = X == null ? -1 : matrix$.MODULE$.realMatrix2RichMatrix(X).rows();
        this.D = X == null ? -1 : matrix$.MODULE$.realMatrix2RichMatrix(X).cols();
        this.Dhalf = (double)this.D() / 2.0;
        this.const = (double)(-this.N()) * this.Dhalf() * FastMath.log((double)(Math.PI * 2)) - precisionX / (double)2 * traceXtX;
        this.DhalfTimesLogPrecisionX = this.Dhalf() * FastMath.log((double)precisionX);
        this.DhalfTimesLogPrecisionW = this.Dhalf() * FastMath.log((double)precisionW);
        this.halfPrecisionX = precisionX / (double)2;
        this.ratioOfPrecisions = precisionW / precisionX;
    }
}

