% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto-ml.R
\name{rank_results.workflow}
\alias{rank_results.workflow}
\alias{rank_results._H2OAutoML}
\alias{rank_results.H2OAutoML}
\alias{collect_metrics.workflow}
\alias{collect_metrics._H2OAutoML}
\alias{collect_metrics.H2OAutoML}
\alias{tidy._H2OAutoML}
\alias{get_leaderboard}
\alias{member_weights}
\alias{extract_fit_parsnip._H2OAutoML}
\alias{extract_fit_engine._H2OAutoML}
\alias{refit.workflow}
\alias{refit._H2OAutoML}
\title{Tools for working with H2O AutoML results}
\usage{
\method{rank_results}{workflow}(x, ...)

\method{rank_results}{`_H2OAutoML`}(x, ...)

\method{rank_results}{H2OAutoML}(x, n = NULL, id = NULL, ...)

\method{collect_metrics}{workflow}(x, ...)

\method{collect_metrics}{`_H2OAutoML`}(x, ...)

\method{collect_metrics}{H2OAutoML}(x, summarize = TRUE, n = NULL, id = NULL, ...)

\method{tidy}{`_H2OAutoML`}(x, n = NULL, id = NULL, keep_model = TRUE, ...)

get_leaderboard(x, n = NULL, id = NULL)

member_weights(x, ...)

\method{extract_fit_parsnip}{`_H2OAutoML`}(x, id = NULL, ...)

\method{extract_fit_engine}{`_H2OAutoML`}(x, id = NULL, ...)

\method{refit}{workflow}(object, ...)

\method{refit}{`_H2OAutoML`}(object, verbosity = NULL, ...)
}
\arguments{
\item{...}{Not used.}

\item{n}{An integer for the number of top models to extract from AutoML
results, default to all.}

\item{id}{A character vector of model ids to retrieve.}

\item{summarize}{A logical; should metrics be summarized over resamples
(TRUE) or return the values for each individual resample.}

\item{keep_model}{A logical value for if the actual model object
should be retrieved from the server. Defaults to \code{TRUE}.}

\item{object, x}{A fitted \code{auto_ml()} model or workflow.}

\item{verbosity}{Verbosity of the backend messages printed during training;
Must be one of NULL (live log disabled), "debug", "info", "warn", "error".
Defaults to NULL.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}}.
}
\description{
Functions that returns a tibble describing model performances.
\itemize{
\item \code{rank_results()} ranks average cross validation performances
of candidate models on each metric.
\item \code{collect_metrics()} computes average statistics of performance metrics
(summarized) for each model, or raw value in each resample (unsummarized).
\item \code{tidy()} computes average performance for each model.
\item \code{member_weights()} computes member importance for stacked ensemble
models, i.e., the relative importance of base models in the meta-learner.
This is typically the coefficient magnitude in the second-level GLM model.
}

\code{extract_fit_engine()} extracts single candidate model from \code{auto_ml()}
results. When \code{id} is null, it returns the leader model.

\code{refit()} re-fits an existing AutoML model to add more candidates. The model
to be re-fitted needs to have engine argument \code{save_data = TRUE}, and
\code{keep_cross_validation_predictions = TRUE} if stacked ensembles is needed for
later models.
}
\details{
H2O associates with each model in AutoML an unique id. This can be used for
model extraction and prediction, i.e., \code{extract_fit_engine(x, id = id)}
returns the model and \code{predict(x, id = id)} will predict for that model.
\code{extract_fit_parsnip(x, id = id)} wraps the h2o model with parsnip
parsnip model object is discouraged.

The \code{algorithm} column corresponds to the model family H2O use for a
particular model, including xgboost (\code{"XGBOOST"}),
gradient boosting (\code{"GBM"}), random forest and variants (\code{"DRF"}, \code{"XRT"}),
generalized linear model (\code{"GLM"}), and neural network (\code{"deeplearning"}).
See the details section in \code{\link[h2o:h2o.automl]{h2o::h2o.automl()}} for more information.
}
\examples{
\dontshow{if (agua:::should_run_examples()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
if (h2o_running()) {
 auto_fit <- auto_ml() \%>\%
   set_engine("h2o", max_runtime_secs = 5) \%>\%
   set_mode("regression") \%>\%
   fit(mpg ~ ., data = mtcars)

   rank_results(auto_fit, n = 5)
   collect_metrics(auto_fit, summarize = FALSE)
   tidy(auto_fit)
   member_weights(auto_fit)
}
\dontshow{\}) # examplesIf}
}
