% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcGrid.R
\name{calcGrid}
\alias{calcGrid}
\title{Calculation of indices over gridded datasets}
\usage{
calcGrid(
  mxnc = NULL,
  mnnc = NULL,
  varnametx = NULL,
  varnametn = NULL,
  fun,
  inienddays,
  dates,
  ncpu = 2,
  out = "test.nc",
  ...
)
}
\arguments{
\item{mxnc}{a path to a NetCDF file(s) with maximum temperature data.}

\item{mnnc}{a path to a NetCDF file(s) with minimum temperature data.}

\item{varnametx}{a character string specifying the name of the variable to extract in maximum temperature NetCDF file.}

\item{varnametn}{a character string specifying the name of the variable to extract in minimum temperature NetCDF file.}

\item{fun}{name of the function to apply over the netcdf file.}

\item{inienddays}{character vector indicating the initial and ending dates in which the input data must be splitted. Dates must be provided in format "YYY-MM-DD".}

\item{dates}{vector of dates corresponding with daily temprature series.}

\item{ncpu}{number of parallel processes to spawn for the use for parallel computation in multiple cores.}

\item{out}{name of the NetCDF file where results will be saved (extension ".nc" must be included).}

\item{...}{specific arguments matching the arguments of the target funcion.}
}
\value{
A NetCDF file is created in the path specified in the "out" parameter.
}
\description{
Calculates any of the agroclimatic indices over a multidimensional dataset
}
\details{
The "inienddays" argument only works if the input daily temperature ncdf file includes the time dimension in the format of "days since YYY-MM-DD". Otherwise, the function will return an error. All the arguments of the target function (function to be applied over the ncdf) must be stated ("...") or an unespecified error will appear. The function uses the argument "ncpu" to split the tasks into different cores taking advantage of the hardware.
}
\examples{
\donttest{
 try(
 calcGrid(mxnc = NULL, mnnc = 'tmin.nc', varnametn = 'tn', fun = 'frostProb', 
          inienddays = NULL, dates = dates, ncpu = 4,  
          out = 'fd_prob.nc', iniday = '07-01', endday = '06-30', 
          type = 'doy', thres = 0, prob = 0.10)
 )
}
}
