% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icREML.R
\name{ic_reml_spt}
\alias{ic_reml_spt}
\title{Find the AIC and BIC for a model fitted using SpATS}
\usage{
ic_reml_spt(model, scale = 1, k = 2, label = "spats")
}
\arguments{
\item{model}{A model fitted using SpATS.}

\item{scale}{A scalar to scale the variance matrix of the estimated
fixed effects (to ensure numerical stability of a log-determinant).
Default value is 1.}

\item{k}{An integer value to round ratios when identifying boundary variance
parameters. Default value is 2.}

\item{label}{A string to label the model. Default value is "spats".}
}
\value{
A data frame.  The data frame has the following components
\itemize{
\item \code{model} : the name of the models
\item \code{loglik} : the full log-likelihood for each model
\item \code{p} :  the number of fixed effects parameters for each model
\item \code{q} : the number of (non-zero) variance parameters for each model.
\item \code{b} : the number of variance parameters that are fixed or on the
boundary.  These parameters are not counted in the AIC or BIC.
\item \code{AIC} : the AIC for each model
\item \code{BIC} : the BIC for each model
\item \code{logdet} : the log-determinant used in adjusting the residual
log-likelihood for each model
}
}
\description{
This function calculates the AIC and BIC for a model fitted in
SpATS following the methodology proposed by Verbyla (2019).
}
\examples{
\donttest{
library(SpATS)
library(agriutilities)
data(wheatdata)
wheatdata$R <- as.factor(wheatdata$row)
wheatdata$C <- as.factor(wheatdata$col)

m1 <- SpATS(
  response = "yield",
  spatial = ~ PSANOVA(col, row, nseg = c(10, 20), nest.div = 2),
  genotype = "geno",
  genotype.as.random = TRUE,
  fixed = ~ colcode + rowcode,
  random = ~ R + C,
  data = wheatdata,
  control = list(tolerance = 1e-03, monitoring = 0)
)

m2 <- SpATS(
  response = "yield",
  spatial = ~ PSANOVA(col, row, nseg = c(10, 20), nest.div = 2),
  genotype = "geno",
  genotype.as.random = TRUE,
  fixed = ~colcode,
  random = ~ R + C,
  data = wheatdata,
  control = list(tolerance = 1e-03, monitoring = 0)
)

rbind.data.frame(
  ic_reml_spt(m1, label = "colcode_rowcode"),
  ic_reml_spt(m2, label = "colcode_no_rowcode")
)

rbind.data.frame(
  h_cullis_spt(m1),
  h_cullis_spt(m2)
)
}
}
\references{
Verbyla, A. P. (2019). A note on model selection using information
criteria for general linear models estimated using REML. Australian &
New Zealand Journal of Statistics, 61(1), 39-50.
}
\author{
Johan Aparicio
}
