% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distrib-exp-adtest.R
\name{exp_test_ad}
\alias{exp_test_ad}
\title{Anderson-Darling Test for Exponentiality}
\usage{
exp_test_ad(x)
}
\arguments{
\item{x}{a non-negative numeric vector of data values}
}
\value{
A list of the class \code{htest} is returned,
just like in many other testing methods,
see, e.g., \code{\link{ks.test}}.
}
\description{
Performs an approximate Anderson-Darling goodness-of-fit
test, which verifies the null hypothesis:
Data follow an exponential distribution.
}
\details{
Sample size should be not less than 3. Missing values
are removed from \code{x} before applying the procedure.

The p-value is approximate: its distribution
has been estimated by taking 2500000 MC samples.
For performance and space reasons,
the estimated distribution is recreated by a spline interpolation
on a fixed number of points.
As a result, the resulting p-value distribution might not necessarily
be uniform for p>>0.5.
}
\references{
Anderson T.W., Darling D.A.,
A Test of Goodness-of-Fit,
\emph{Journal of the American Statistical Association} 49,
1954, pp. 765-769.
}
\seealso{
\code{\link{pexp}}

Other Tests: \code{\link{pareto2_test_ad}},
  \code{\link{pareto2_test_f}}
}
\concept{Tests}
