% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel-other.R
\name{rel_graph}
\alias{rel_graph}
\title{Create an Adjacency Matrix Representing a Binary Relation}
\usage{
rel_graph(x, pord, ...)
}
\arguments{
\item{x}{list with elements to compare, preferably named}

\item{pord}{a function with two arguments, returning a single boolean value,
e.g. \code{\link{pord_spread}},
\code{\link{pord_nd}}, or \code{\link{pord_weakdom}}}

\item{...}{additional arguments passed to \code{pord}}
}
\value{
Returns a square logical matrix.
\code{\link{dimnames}} of the matrix correspond
to \code{\link{names}} of \code{x}.
}
\description{
Returns a binary relation that represents results
of comparisons with \code{pord}
of all pairs of elements in \code{x}.
We have \code{ret[i,j] == pord(x[[i]], x[[j]], ...)}.
}
\seealso{
Other binary_relations: \code{\link{check_comonotonicity}},
  \code{\link{pord_nd}}, \code{\link{pord_spread}},
  \code{\link{pord_weakdom}},
  \code{\link{rel_is_antisymmetric}},
  \code{\link{rel_is_asymmetric}},
  \code{\link{rel_is_cyclic}},
  \code{\link{rel_is_irreflexive}},
  \code{\link{rel_is_reflexive}},
  \code{\link{rel_is_symmetric}},
  \code{\link{rel_is_total}},
  \code{\link{rel_is_transitive}},
  \code{\link{rel_reduction_hasse}}
}
\concept{binary_relations}
