% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-summary-statistics.R
\name{validate_transformation}
\alias{validate_transformation}
\alias{validate_transformation.aghqtrans}
\alias{validate_transformation.list}
\alias{validate_transformation.default}
\title{Validate a transformation object}
\usage{
validate_transformation(...)

\method{validate_transformation}{aghqtrans}(trans, checkinverse = FALSE, ...)

\method{validate_transformation}{list}(translist, checkinverse = FALSE, ...)

\method{validate_transformation}{default}(...)
}
\arguments{
\item{...}{Used to pass arguments to methods.}

\item{trans}{A transformation object of class \code{aghqtrans} returned by \code{make_transformation}.}

\item{checkinverse}{Default \code{FALSE}, do not check that \code{totheta(fromtheta(theta)) = theta}. Otherwise,
a vector of values for which to perform that check. No default values are provided, since \code{validate_transformation}
has no way of determining the domain and range of \code{totheta} and \code{fromtheta}. This argument is
used internally in \code{aghq} package functions, with cleverly chosen check values.}

\item{translist}{A list. Will be checked, passed to \code{aghqtrans}, and then checked again.}
}
\value{
\code{TRUE} if the function runs to completion without throwing an error.
}
\description{
Routine for checking whether a given transformation is valid.
}
\details{
This function checks that:
\itemize{
\item{The supplied object contains elements \code{totheta}, \code{fromtheta}, and \code{jacobian}, and that they are all functions,}
\item{If \code{checkinverse} is a vector of numbers, then it checks that \code{totheta(fromtheta(checkinverse)) == checkinverse}.}
}
In addition, if a \code{list} is provided, the function first checks that it contains the right elements,
then passes it to \code{make_transformation}, then checks that.

This function throws an informative error messages when checks don't pass or themselves throw errors.
}
\examples{

t <- make_transformation(log,exp)
validate_transformation(t)
t2 <- list(totheta = log,fromtheta = exp)
validate_transformation(t2)
\dontrun{
t3 <- make_transformation(log,log)
checkvals <- exp(exp(rnorm(10)))
# Should throw an informative error because log isn't the inverse of log.
validate_transformation(t3,checkinverse = checkvals)
}
}
\seealso{
Other transformations: 
\code{\link{default_transformation}()},
\code{\link{make_transformation}()}
}
\concept{transformations}
