% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/africamonitor.R
\docType{package}
\name{africamonitor-package}
\alias{africamonitor-package}
\alias{africamonitor}
\title{Africa Macroeconomic Monitor Database API}
\description{
An R API providing access to a relational database with macroeconomic data for Africa. The
database is maintained at the Kiel Institute for the World Economy.
}
\section{Functions}{

Functions and data providing information about the available data

\code{\link[=am_sources]{am_sources()}}\cr
\code{\link[=am_series]{am_series()}}\cr
\code{\link{am_countries}}\cr
\code{\link{am_entities}}

Function to retrieve the data from the database

\code{\link[=am_data]{am_data()}}

Functions to reshape data and add temporal identifiers

\code{\link[=am_pivot_wider]{am_pivot_wider()}}\cr
\code{\link[=am_pivot_longer]{am_pivot_longer()}}\cr
\code{\link[=am_expand_date]{am_expand_date()}}

% Function to export wide format data to Excel
%
% \code{\link[=am_write_excel]{am_write_excel()}}\cr
%
Helper functions to convert inputs to R dates

\code{\link[=am_as_date]{am_as_date()}}\cr
% \code{\link[=am_transpose]{am_transpose()}}\cr

Global Macros with core ID variables in the database

\code{\link{.AMID}}\cr
\code{\link{.AMT}}
}

