% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trigonometry.r
\name{trigonometric-functions}
\alias{trigonometric-functions}
\alias{sine}
\alias{cosine}
\alias{tangent}
\alias{secant}
\alias{cosecant}
\alias{cotangent}
\title{Angle vector aware trigonometric functions}
\usage{
sine(x, unit = getOption("affiner_angular_unit", "degrees"))

cosine(x, unit = getOption("affiner_angular_unit", "degrees"))

tangent(x, unit = getOption("affiner_angular_unit", "degrees"))

secant(x, unit = getOption("affiner_angular_unit", "degrees"))

cosecant(x, unit = getOption("affiner_angular_unit", "degrees"))

cotangent(x, unit = getOption("affiner_angular_unit", "degrees"))
}
\arguments{
\item{x}{An angle vector or an object to convert to it (such as a numeric vector)}

\item{unit}{A string of the desired angular unit.  Supports the following strings
(note we ignore any punctuation and space characters as well as any trailing \code{s}'s
e.g. "half turns" will be treated as equivalent to "halfturn"):
\itemize{
\item "deg" or "degree"
\item "half-revolution", "half-turn", or "pi-radian"
\item "gon", "grad", "grade", or "gradian"
\item "rad" or "radian"
\item "rev", "revolution", "tr", or "turn"
}}
}
\value{
A numeric vector
}
\description{
\code{sine()}, \code{cosine()}, \code{tangent()}, \code{secant()}, \code{cosecant()}, and \code{cotangent()} are
\code{\link[=angle]{angle()}} aware trigonometric functions that allow for a user chosen angular unit.
}
\examples{
sine(pi, "radians")
cosine(180, "degrees")
tangent(0.5, "turns")

a <- angle(0.5, "turns")
secant(a)
cosecant(a)
cotangent(a)
}
