% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affineGrob.r
\name{affineGrob}
\alias{affineGrob}
\alias{grid.affine}
\title{Affine transformation grob}
\usage{
affineGrob(
  grob,
  vp_define = NULL,
  transform = NULL,
  vp_use = NULL,
  name = NULL,
  gp = grid::gpar(),
  vp = NULL
)

grid.affine(...)
}
\arguments{
\item{grob}{A grid grob to perform affine transformations on.  Passed to \code{\link[grid:grid.group]{grid::defineGrob()}} as its \code{src} argument.}

\item{vp_define}{\code{\link[grid:viewport]{grid::viewport()}} to define grid group in.  Passed to \code{\link[grid:grid.group]{grid::defineGrob()}} as its \code{vp} argument.
This will cumulative with the current viewport and the \code{vp} argument (if any),
if this cumulative viewport falls outside the graphics device drawing area this
grob may be clipped on certain graphics devices.}

\item{transform}{An affine transformation function.
If \code{NULL} default to \code{\link[grid:viewportTransform]{grid::viewportTransform()}}.
Passed to \code{\link[grid:grid.group]{grid::useGrob()}} as its \code{transform} argument.}

\item{vp_use}{\code{\link[grid:viewport]{grid::viewport()}} passed to \code{\link[grid:grid.group]{grid::useGrob()}} as its \code{vp} argument.}

\item{name}{A character identifier (for grid).}

\item{gp}{A \code{\link[grid:gpar]{grid::gpar()}} object.}

\item{vp}{A \code{\link[grid:viewport]{grid::viewport()}} object (or \code{NULL}).}

\item{...}{Passed to \code{affineGrob()}}
}
\value{
A \code{\link[grid:grid.grob]{grid::gTree()}} (grob) object of class "affine".
As a side effect \code{grid.affine()} draws to the active graphics device.
}
\description{
\code{affineGrob()} is a grid grob function to facilitate
using the group affine transformation features introduced in R 4.2.
}
\examples{
if (require("grid")) {
  grob <- grobTree(rectGrob(gp = gpar(fill = "blue", col = NA)),
                   circleGrob(gp=gpar(fill="yellow", col = NA)),
                   textGrob("RSTATS", gp=gpar(fontsize=32)))
  grid.newpage()
  pushViewport(viewport(width=unit(4, "in"), height=unit(2, "in")))
  grid.draw(grob)
  popViewport()
}

if (require("grid") &&
    getRversion() >= "4.2.0" &&
    isTRUE(dev.capabilities()$transformations)) {
  # Only works if active graphics device supports affine transformations
  # such as `png(type="cairo")` on R 4.2+
  vp_define <- viewport(width=unit(2, "in"), height=unit(2, "in"))
  affine <- affineGrob(grob, vp_define=vp_define)
  grid.newpage()
  pushViewport(viewport(width=unit(4, "in"), height=unit(2, "in")))
  grid.draw(affine)
  popViewport()
}
if (require("grid") &&
    getRversion() >= "4.2.0" &&
    isTRUE(dev.capabilities()$transformations)) {
  # Only works if active graphics device supports affine transformations
  # such as `png(type="cairo")` on R 4.2+
  settings <- affine_settings(xy = list(x = c(3/3, 2/3, 0/3, 1/3),
                                        y = c(2/3, 1/3, 1/3, 2/3)),
                              unit = "snpc")
  affine <- affineGrob(grob,
                       vp_define = vp_define,
                       transform = settings$transform,
                       vp_use = settings$vp)
  grid.newpage()
  grid.draw(affine)
}
}
\seealso{
See \code{\link[=affine_settings]{affine_settings()}} for computing good \code{transform} and \code{vp_use} settings.
See \url{https://www.stat.auckland.ac.nz/~paul/Reports/GraphicsEngine/groups/groups.html}
for more information about the group affine transformation feature.
See \code{\link[=isocubeGrob]{isocubeGrob()}} which wraps this function to render isometric cubes.
}
