% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/methods.afex_aov.R
\name{afex_aov-methods}
\alias{afex_aov-methods}
\alias{anova.afex_aov}
\alias{lsm.basis.afex_aov}
\alias{print.afex_aov}
\alias{recover.data.afex_aov}
\alias{summary.afex_aov}
\title{Methods for afex_aov objects}
\usage{
\method{anova}{afex_aov}(object, es = afex_options("es_aov"),
  observed = NULL, correction = afex_options("correction_aov"),
  MSE = TRUE, intercept = FALSE, ...)

\method{print}{afex_aov}(x, ...)

\method{summary}{afex_aov}(object, ...)

\method{recover.data}{afex_aov}(object, ...)

\method{lsm.basis}{afex_aov}(object, trms, xlev, grid, ...)
}
\arguments{
\item{object,x}{object of class \code{afex_aov} as returned from \code{\link{aov_car}} and related functions.}

\item{es}{Effect Size to be reported. The default is given by \code{afex_options("es_aov")}, which is initially set to \code{"ges"} (i.e., reporting generalized eta-squared, see details). Also supported is partial eta-squared (\code{"pes"}) or \code{"none"}.}

\item{observed}{character vector referring to the observed (i.e., non manipulated) variables/effects in the design. Important for calculation of generalized eta-squared (ignored if \code{es} is not \code{"ges"}), see details.}

\item{correction}{Character. Which sphericity correction of the degrees of freedom should be reported for the within-subject factors.  The default is given by \code{afex_options("correction_aov")}, which is initially set to \code{"GG"} corresponding to the Greenhouse-Geisser correction. Possible values are \code{"GG"}, \code{"HF"} (i.e., Hyunh-Feldt correction), and \code{"none"} (i.e., no correction).}

\item{MSE}{logical. Should the column containing the Mean Sqaured Error (MSE) be displayed? Default is \code{TRUE}.}

\item{intercept}{logical. Should intercept (if present) be included in the ANOVA table? Default is \code{FALSE} which hides the intercept.}

\item{...}{further arguments passed through, see description of return value for details.}

\item{trms,xlev,grid}{same as for \code{\link{lsm.basis}}.}
}
\value{
\describe{
  \item{\code{anova}}{Returns an ANOVA table of class \code{c("anova", "data.frame")}. Information such as effect size (\code{es}) or df-correction are calculated each time this method is called.}
  \item{\code{summary}}{For ANOVAs containing within-subject factors it returns the full output of the within-subject tests: the uncorrected results, results containing Greenhousse-Geisser and Hyunh-Feldt correction, and the results of the Mauchly test of sphericity (all achieved via \code{summary.Anova.mlm}). For other ANOVAs, the \code{anova} table is simply returned.}
  \item{\code{print}}{Prints (and invisibly returns) the ANOVA table as constructed from \code{\link{nice}} (i.e., as strings rounded nicely). Arguments in \code{...} are passed to \code{nice} allowing to pass arguments such as \code{es} and \code{correction}.}
  \item{\code{recover.data} and \code{lsm.basis}}{Provide the backbone for using \code{\link{lsmeans}} and related functions from \pkg{lsmeans} directly on \code{afex_aov} objects by returning a \code{\link{ref.grid}} object. Should not be called directly but through the functionality provided by \pkg{lsmeans}.}

}
}
\description{
Methods defined for objects returned from the ANOVA functions \code{\link{aov_car}} et al. of class \code{afex_aov} containing both the ANOVA fitted via \code{car::Anova} and base R's \code{aov}.
}

