% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{extract_samples}
\alias{extract_samples}
\title{Extract posterior samples from a model fit.}
\usage{
extract_samples(fit, inc_warmup = FALSE, inc_lp = FALSE,
  as.list = FALSE)
}
\arguments{
\item{fit}{A list returned by \code{sample_tmb} or \code{sample_admb}.}

\item{inc_warmup}{Whether to extract the warmup samples or not
(default). Warmup samples should never be used for inference, but may
be useful for diagnostics.}

\item{inc_lp}{Whether to include a column for the log posterior density
(last column). For diagnostics it can be useful.}

\item{as.list}{Whether to return the samples as a list (one element per
chain). This could then be converted to a CODA mcmc object.}
}
\value{
If as.list is FALSE, an invisible data.frame containing samples
  (rows) of each parameter (columns). If multiple chains exist they will
  be rbinded together, maintaining order within each chain. If as.list
  is TRUE, samples are returned as a list of matrices.
}
\description{
A helper function to extract posterior samples across multiple chains
into a single data.frame.
}
\details{
This function is loosely based on the \pkg{rstan} function
  \code{extract}. Merging samples across chains should only be used for
  inference after appropriate diagnostic checks. Do not calculate
  diagnostics like Rhat or effective sample size after using this
  function, instead, use \code{\link[rstan]{monitor}}. Likewise, warmup
  samples are not valid and should never be used for inference, but may
  be useful in some cases for diagnosing issues.
}
\examples{
## A previously run fitted TMB model
fit <- readRDS(system.file('examples', 'fit_tmb.RDS', package='adnuts'))
post <- extract_samples(fit)
tail(apply(post, 2, median))
}
