% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_time.R
\name{get_time}
\alias{get_time}
\title{Determine times based on age-depth model}
\usage{
get_time(x, h, hiat_mode = "start", 
bdry_pts_hiat = "destructive", out_dom_val_t = "default")
}
\arguments{
\item{x}{an \emph{adm} or \emph{multiadm} object}

\item{h}{vector of stratigraphic positions}

\item{hiat_mode}{"start", "end", or "destroy". If a stratigraphic position coincides with a hiatus, what should be returned?}

\item{bdry_pts_hiat}{"consistent" or "destructive". How are hiatuses at the start/end of the adm treated?}

\item{out_dom_val_t}{:"default", "time_limits", or a numeric value. What value is returned for heights not covered by the age-depth model?}
}
\value{
numeric vector. Times of deposition of the provided heights in h
}
\description{
Takes an age-depth model and vector of stratigraphic positions to determine
the corresponding time of formation
}
\details{
If a stratigraphic position
coincides with a hiatus, should the start time or the end time of the hiatus be returned?
Using "destroy" retruns NA
If the adm starts/ends with a hiatus, should
the time returned be consistent with \emph{hiat_mode}, or should it be NA?
}
