% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{fast_plot}
\alias{fast_plot}
\title{Fast version of graph plotting.}
\usage{
fast_plot(x, ordered_leaves = NULL, show_admixture_labels = FALSE,
  show_inner_node_labels = FALSE, ...)
}
\arguments{
\item{x}{The admixture graph.}

\item{ordered_leaves}{The leaf-nodes in the left to right order they
should be drawn.}

\item{show_admixture_labels}{A flag determining if the plot should include
the names of admixture proportions.}

\item{show_inner_node_labels}{A flag determining if the plot should include
the names of inner nodes.}

\item{...}{Additional plotting options.}
}
\value{
A plot.
}
\description{
This is a fast, deterministic and stand-alone function for visualizing the
admixture graph. Has the bad habit if sometimes drawing several nodes at the
exact same coordinates; for clearer reasults try \code{\link{plot.agraph}}
(which, on the other hand, relies on numerical optimising of a compicated cost
function and might be unpredictable).
}
\examples{
# taken from the collection of all the admixture graphs with four leaves and at
# most two admixture events:

fast_plot(four_leaves_graphs[[24]](c("A", "B", "C", "D")))

# To be fair, here is a graph that looks all right:

fast_plot(four_leaves_graphs[[25]](c("A", "B", "C", "D")))

}
\seealso{
\code{\link{plot.agraph}}
}

