% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mcmc.R
\name{model_likelihood_n}
\alias{model_likelihood_n}
\title{Computes the likelihood of a model from samples from its posterior distribution.}
\usage{
model_likelihood_n(log_likelihoods, no_samples = 100)
}
\arguments{
\item{log_likelihoods}{Samples of log likelihoods from the posterior distribution of the graph.}

\item{no_samples}{Number of permutations to sample when computing the result.}
}
\value{
The likelihood of a graph where graph parameters are integrated out given as the mean and standard
                          deviation over \code{no_samples} different permutations of the input.
}
\description{
The likelihood of a graph can be computed by integrating over all the graph parameters (with appropriate priors).
Doing this by sampling from priors is very inefficient, so we use samples from the posteriors to importance
sample the likelihood.
}
\details{
The numerical issues with adding a lot of numbers in log space is unstable
so we get a better estimate by doing it several times on different permutations
of the data.This function calculates the mean of the likelihoods over different permutations of the
input and estimates the standard devition.
}

