% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/propose.R
\docType{data}
\name{eight_leaves_trees}
\alias{eight_leaves_trees}
\title{Eight leaves trees.}
\format{\preformatted{List of 3
 $ tree_1:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1693 12 1713 3 12 3 1693 1713
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ tree_2:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1715 12 1735 3 12 3 1715 1735
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
 $ tree_3:function (leaves)  
  ..- attr(*, "srcref")=Class 'srcref'  atomic [1:8] 1737 12 1757 3 12 3 1737 1757
  .. .. ..- attr(*, "srcfile")=Classes 'srcfilecopy', 'srcfile' <environment: 0x000000000c8144d8> 
}}
\usage{
eight_leaves_trees
}
\value{
A list of functions on eight leaves.
        The outputs of these functions are \code{\link{agraph}} objects.
}
\description{
A comprehensive listing of three unrooted trees with eight leaves.
The position of the root can be moved later with the function
\code{\link{make_an_outgroup}}.
}
\examples{
\donttest{
# While the usage of this function is pretty self-explanatory, let's plot all the graphs
# just for browsing.
for (i in seq(1, length(eight_leaves_trees))) {
  graph <- eight_leaves_trees[[i]](c("A", "B", "C", "D", "E", "F", "G", "H"))
  # This is how you include quotation marks in strings by the way:
  title <- paste("eight_leaves_trees[[", i,
                 "]](c(\\"A\\", \\"B\\", \\"C\\", \\"D\\", \\"E\\", \\"F\\", \\"G\\", \\"H\\"))", sep = "")
  plot(graph, color = "brown", title = title)
}
}
}
\seealso{
\code{\link{make_permutations}}

\code{\link{fit_permutations_and_graphs}}

\code{\link{add_a_leaf}}

\code{\link{add_an_admixture}}

\code{\link{add_an_admixture2}}

\code{\link{make_an_outgroup}}

Other graphs: \code{\link{five_leaves_graphs}};
  \code{\link{four_leaves_graphs}};
  \code{\link{seven_leaves_trees}};
  \code{\link{six_leaves_graphs}}
}
\keyword{datasets}

