% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_interp_records.R
\name{derive_interp_records}
\alias{derive_interp_records}
\title{Derive interpolated rows for the CDC charts (>=2 yrs old)}
\usage{
derive_interp_records(dataset, by_vars = NULL, parameter)
}
\arguments{
\item{dataset}{Input metadataset

The variables \code{AGE}, \code{AGEU}, \code{SEX}, \code{L}, \code{M}, \code{S} are expected to be in the dataset

For BMI the additional variables \code{P95} and \code{Sigma} are expected to be in the dataset

Note that \code{AGE} must be in days so that \code{AGEU} is equal to \code{"DAYS"}}

\item{by_vars}{Grouping variables

The variable from \code{dataset} which identifies the group of observations
to interpolate separately.}

\item{parameter}{CDC/WHO metadata parameter

\emph{Permitted Values}: \code{"WEIGHT"}, \code{"HEIGHT"} or \code{"BMI"} only - Must not be \code{NULL}
e.g. \code{parameter = "WEIGHT"}, \code{parameter = "HEIGHT"}, or   \code{parameter = "BMI"}.}
}
\value{
The input dataset plus additional interpolated records: a record for
each day from the minimum age to the maximum age.

If any variables in addition to the expected ones are in the input dataset,
LOCF (Last Observation Carried Forward) is applied to populate them for the
new records.
}
\description{
Derive a linear interpolation of rows for the CDC charts (>=2 yrs old) by age in days
for the following parameters: HEIGHT, WEIGHT and BMI
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(rlang, warn.conflicts = FALSE)

cdc_htage <- admiralpeds::cdc_htage \%>\%
  mutate(
    SEX = case_when(
      SEX == 1 ~ "M",
      SEX == 2 ~ "F",
      TRUE ~ NA_character_
    ),
    # Ensure first that Age unit is "DAYS"
    AGE = round(AGE * 30.4375),
    AGEU = "DAYS"
  )

# Interpolate the AGE by SEX
derive_interp_records(
  dataset = cdc_htage,
  by_vars = exprs(SEX),
  parameter = "HEIGHT"
)
}
\seealso{
Metadata
\code{\link{cdc_bmiage}},
\code{\link{cdc_htage}},
\code{\link{cdc_wtage}},
\code{\link{who_bmi_for_age_boys}},
\code{\link{who_bmi_for_age_girls}},
\code{\link{who_hc_for_age_boys}},
\code{\link{who_hc_for_age_girls}},
\code{\link{who_lgth_ht_for_age_boys}},
\code{\link{who_lgth_ht_for_age_girls}},
\code{\link{who_wt_for_age_boys}},
\code{\link{who_wt_for_age_girls}},
\code{\link{who_wt_for_lgth_boys}},
\code{\link{who_wt_for_lgth_girls}}
}
\concept{metadata}
\keyword{metadata}
