% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_list_of}
\alias{assert_list_of}
\title{Is an Argument a List of Objects of a Specific S3 Class or Type?}
\usage{
assert_list_of(arg, class, named = FALSE, optional = TRUE)
}
\arguments{
\item{arg}{A function argument to be checked}

\item{class}{The S3 class or type to check for}

\item{named}{If set to \code{TRUE}, an error is issued if not all elements of the
list are named.}

\item{optional}{Is the checked argument optional? If set to \code{FALSE} and \code{arg}
is \code{NULL} then an error is thrown}
}
\value{
The function throws an error if \code{arg} is not a list or if \code{arg} is a list but
its elements are not objects inheriting from \code{class} or of type \code{class}.
Otherwise, the input is returned invisibly.
}
\description{
Checks if an argument is a \code{list} of objects inheriting from the S3 class or type specified.
}
\examples{
example_fun <- function(list) {
  assert_list_of(list, "data.frame")
}

example_fun(list(mtcars, iris))

try(example_fun(list(letters, 1:10)))

try(example_fun(c(TRUE, FALSE)))

example_fun2 <- function(list) {
  assert_list_of(list, "numeric", named = TRUE)
}
try(example_fun2(list(1, 2, 3, d = 4)))
}
\seealso{
Checks for valid input and returns warning or errors messages: 
\code{\link{assert_atomic_vector}()},
\code{\link{assert_character_scalar}()},
\code{\link{assert_character_vector}()},
\code{\link{assert_data_frame}()},
\code{\link{assert_date_vector}()},
\code{\link{assert_expr_list}()},
\code{\link{assert_expr}()},
\code{\link{assert_filter_cond}()},
\code{\link{assert_function}()},
\code{\link{assert_integer_scalar}()},
\code{\link{assert_list_element}()},
\code{\link{assert_logical_scalar}()},
\code{\link{assert_named}()},
\code{\link{assert_numeric_vector}()},
\code{\link{assert_one_to_one}()},
\code{\link{assert_param_does_not_exist}()},
\code{\link{assert_s3_class}()},
\code{\link{assert_same_type}()},
\code{\link{assert_symbol}()},
\code{\link{assert_unit}()},
\code{\link{assert_vars}()},
\code{\link{assert_varval_list}()}
}
\concept{assertion}
\keyword{assertion}
