% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04fileOperations.r
\docType{methods}
\name{put.adf.file}
\alias{put.adf.file}
\alias{put.adf.file,amigaDisk,raw,character,POSIXt,character-method}
\alias{put.adf.file,amigaDisk,raw,character,POSIXt,missing-method}
\alias{put.adf.file,amigaDisk,raw,character,missing,missing-method}
\alias{put.adf.file,amigaDisk,character,character,POSIXt,character-method}
\alias{put.adf.file,amigaDisk,character,character,POSIXt,missing-method}
\alias{put.adf.file,amigaDisk,character,character,missing,missing-method}
\alias{put.adf.file,amigaDisk,character,missing,missing,missing-method}
\title{Put a file onto an amigaDisk object}
\usage{
\S4method{put.adf.file}{amigaDisk,raw,character,POSIXt,character}(x, source, destination, date, comment)

\S4method{put.adf.file}{amigaDisk,raw,character,POSIXt,missing}(x, source, destination, date, comment)

\S4method{put.adf.file}{amigaDisk,raw,character,missing,missing}(x, source, destination, date, comment)

\S4method{put.adf.file}{amigaDisk,character,character,POSIXt,character}(x, source, destination, date, comment)

\S4method{put.adf.file}{amigaDisk,character,character,POSIXt,missing}(x, source, destination, date, comment)

\S4method{put.adf.file}{amigaDisk,character,character,missing,missing}(x, source, destination, date, comment)

\S4method{put.adf.file}{amigaDisk,character,missing,missing,missing}(x, source, destination, date, comment)
}
\arguments{
\item{x}{An \code{\link{amigaDisk}} onto which the file should be put.}

\item{source}{Either a \code{character} string of the source
file's path; or a \code{vector} of \code{raw} data that
should be written to the destination file. Wildcards are not allowed (see details)}

\item{destination}{A \code{character} string of the destination
path on the virtual floppy disk where the source file should be put. The
path should be conform Amiga specs (see \code{\link{current.adf.dir}}). When
the destination is missing or only specifies a directory, the file will be put
into the current directory (\code{\link{current.adf.dir}}) or specified path of
\code{x} respectively. In that case, the same file name as that
of the source file is used. Wild cards are not allowed (see details).}

\item{date}{A \code{\link[base:DateTimeClasses]{POSIXt}} object that will be used as the
file modification date. When missing the system time will used.}

\item{comment}{An optional \code{character} string that will be included
in the file header as a comment. Should not be longer than 79 characters.}
}
\value{
Returns an \code{\link{amigaDisk}} object onto which the
source file is put at the specified destination.
}
\description{
Put a file onto a virtual Amiga floppy disk represented by
an \code{\link{amigaDisk}} object.
}
\details{
Put a file or raw data from your local system onto a virtual
Amiga floppy disk represented by an \code{\link{amigaDisk}}
object. Make sure that the virtual disk is DOS formatted.
This method can only put one file at a time onto the virtual
virtual disk. It is therefore not allowed to use wild cards
in the source or destination names. Use loops to add multiple
files onto a virtual disk.
}
\examples{
\dontrun{
## create a blank disk to put files onto:
blank.disk <- blank.amigaDOSDisk("blank", "DD", "OFS", TRUE, FALSE, FALSE)

## let's copy the base package 'INDEX' file onto the
## virtual disk:
blank.disk <- put.adf.file(blank.disk, system.file("INDEX"))

## We can also put raw data onto the virtual disk:
blank.disk <- put.adf.file(blank.disk, raw(2048), "DF0:null.dat")

## check whether we succeeded:
list.adf.files(blank.disk)
}
}
\author{
Pepijn de Vries
}
