% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01genericSupport.r
\docType{methods}
\name{get.diskLocation}
\alias{get.diskLocation}
\alias{get.diskLocation,character,numeric-method}
\title{Get the physical location on the disk for a specific block}
\usage{
\S4method{get.diskLocation}{character,numeric}(disktype, block)
}
\arguments{
\item{disktype}{A \code{character} string indicating the type of disk:
\code{DD} for double density disks. \code{HD} for high density disks.}

\item{block}{\code{numeric} identifier of a block. Whole numbers ranging from
0 up to 1759 (for DD disks) or 3519 (for HD disks). Note that the base
index is zero (for consitency with Amiga specifications and documentation)
opposed to the base of one used in R.}
}
\value{
Returns a \code{list} with corresponding sector, side and cylinder
identifiers (\code{numeric}).
}
\description{
Get the side, cylinder and sector on a disk, based on disk type and
block id.
}
\details{
Data on amiga floppy disks are stored as 512 byte blocks. These blocks
are physically stored on a specific cylinder and side at a specific sector.
This method returns the identifiers for the physical location based on the
block identifier. The inverse of this function is achieved with the
\code{\link{get.blockID}} method.
}
\examples{
## get the physical location of the first 20 blocks on a DD disk
## and arrange as a data.frame:
as.data.frame(get.diskLocation("DD", 0:19))
}
\seealso{
Other block.operations: \code{\link{amigaBlock-method}},
  \code{\link{get.blockID}}
}
\author{
Pepijn de Vries
}
