% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02amigaDiskBasics.r
\docType{methods}
\name{get.adf.file}
\alias{get.adf.file}
\alias{get.adf.file,amigaDisk,character,missing-method}
\alias{get.adf.file,amigaDisk,character,character-method}
\alias{get.adf.file,amigaDisk,character,ANY-method}
\title{Get a file from an amigaDisk object}
\usage{
\S4method{get.adf.file}{amigaDisk,character,missing}(x, source, destination)

\S4method{get.adf.file}{amigaDisk,character,character}(x, source, destination)

\S4method{get.adf.file}{amigaDisk,character,ANY}(x, source, destination)
}
\arguments{
\item{x}{An \code{\link{amigaDisk}} object from which a file
needs to be extracted.}

\item{source}{Specify the source file's path on the
\code{\link{amigaDisk}} object, conform Amiga specs. See
\code{\link{current.adf.dir}} for details on these specs.}

\item{destination}{either a file name or a file connection, that
allows writing binary data (see e.g., \code{\link[base]{file}} or
\code{\link[base]{url}}).}
}
\value{
Returns a \code{vector} of \code{raw} data when the
argument \code{destination} is missing. Otherwise returns nothing.
}
\description{
Get files stored on virtual \code{\link{amigaDisk}}s as raw data
or copy as file.
}
\details{
Amiga DOS formatted disks can store any kind of file (as long
as the disk's capacity allows it). Use this method to extract
such files embedded in an Amiga Disk File (ADF) as raw data or
copy to a file on your system.
}
\examples{
data(adf.example)

\dontrun{
## get the file "Startup-Sequence" from the virtual
## example disk and save as a text file in the
## current working directory:
get.adf.file(adf.example, "DF0:S/Startup-Sequence", "startup.txt")
}

## get the same file as raw data
## by omitting the destination:
startup <- get.adf.file(adf.example, "DF0:S/Startup-Sequence")

## Look, it's a text file:
cat(rawToChar(startup))

if (requireNamespace("ProTrackR", quietly = TRUE)) {
  ## look there is a typical ProTracker module on
  ## the example disk. You can load it like this:
  
  ## get the file from the virtual disk
  ## as raw data
  mod.raw <- get.adf.file(adf.example, "DF0:mods/mod.intro")

  ## open a raw connection with the
  ## newly imported raw data
  con <- rawConnection(mod.raw, "rb")

  ## and read it as a ProTracker module
  mod <- ProTrackR::read.module(con)
  close(con)
  
  ## plot the first sample from the module:
  plot(ProTrackR::waveform(ProTrackR::PTSample(mod, 1)),
       type = "l", ylab = "amplitude")
} else {
  cat("You need to install and load the\\nProTrackR package for this part of the example.")
}
}
\author{
Pepijn de Vries
}
