% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_estimator.R
\name{evaluate_scenarios_parallel}
\alias{evaluate_scenarios_parallel}
\title{Evaluate different scenarios in parallel}
\usage{
evaluate_scenarios_parallel(
  score_lists,
  estimator_lists,
  data_distribution_lists,
  use_full_twoarm_sampling_distribution_lists,
  design_lists,
  true_parameter_lists,
  mu_lists,
  sigma_lists,
  tol_lists,
  maxEval_lists,
  absError_lists,
  exact_lists,
  early_futility_part_lists,
  continuation_part_lists,
  early_efficacy_part_lists,
  conditional_integral_lists
)
}
\arguments{
\item{score_lists}{a list of lists of estimator scores.}

\item{estimator_lists}{a list of lists of estimators.}

\item{data_distribution_lists}{a list of lists of data distributions.}

\item{use_full_twoarm_sampling_distribution_lists}{a list of lists of use_full_twoarm_sampling_distribution_lists parameters.}

\item{design_lists}{a list of lists of designs.}

\item{true_parameter_lists}{a list of lists of true parameters.}

\item{mu_lists}{a list of lists of mu vectors.}

\item{sigma_lists}{a list of lists of sigma values.}

\item{tol_lists}{a list of lists of relative tolerances.}

\item{maxEval_lists}{a list of lists of maxEval boundaries.}

\item{absError_lists}{a list of lists of absError boundaries.}

\item{exact_lists}{a list of lists of `exact` parameters.}

\item{early_futility_part_lists}{a list of lists of `early_futility_part_lists` parameters.}

\item{continuation_part_lists}{a list of lists of `continuation_part_lists` parameters.}

\item{early_efficacy_part_lists}{a list of lists of `early_efficacy_part_lists` parameters.}

\item{conditional_integral_lists}{a list of lists of `conditional_integral_lists` parameters.}
}
\value{
a list of data.frames containing the results for the respective scenarios.
}
\description{
This function takes a list of lists of scores, a list of lists of estimators,
and lists lists of various other design parameters. Each possible combination
of the elements of the respective sublists is then used to create separate
scenarios.
These scenarios are than evaluated independelty of each other,
allowing for parallelization via the \code{\link[future:future]{future}} framework. For each scenario,
one call to the \code{\link{evaluate_estimator}} function is made.
}
\details{
Concretely, the cross product of
the first sublist of scores and the first sublist of estimators and the other parameters
is calculated. Then the cross product of the second sublist of scores, estimators
and other design parameters is calculated. All of these cross products together
make up the set of all scenarios. The combinations say the first sublist of scores
and the second sublist of estimators are not considered.
}
\examples{
res <-evaluate_scenarios_parallel(
 score_lists = list(c(MSE(), OverestimationProbability())),
 estimator_lists =  list(c(SampleMean(), FirstStageSampleMean())),
 data_distribution_lists = list(c(Normal(FALSE), Normal(TRUE))),
 design_lists =  list(c(get_example_design())),
 mu_lists = list(c(-1, 0, 1)),
 sigma_lists = list(1)
)

}
\seealso{
[evaluate_estimator]
}
