% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.constr.hclust.R
\name{plot.constr.hclust}
\alias{plot.constr.hclust}
\title{Plotting Method For Space- And Time-Constrained Clustering}
\usage{
\method{plot}{constr.hclust}(x, k, xlim, ylim, links, points=TRUE,
hybrids=c("change","single","none"), lty.hyb=1L, lwd.hyb=1, col.hyb="black",
plot=TRUE, col, axes, cex=1, lty, lwd, lwd.pt=1, invert.axes=FALSE, ...)
}
\arguments{
\item{x}{A \code{\link{constr.hclust-class}} object}

\item{k}{The number of clusters to delineate}

\item{xlim}{Limits, in abscissa, of the zone to be plotted}

\item{ylim}{Limits, in ordinate, of the zone to be plotted}

\item{links}{Should segments be drawn to represent the edges (links)
(default: FALSE)}

\item{points}{Should observation points be drawn (default: TRUE)}

\item{hybrids}{How should hybrid segments be drawn (default: "change")}

\item{lty.hyb}{Line type to use for hybrid segments (default: lty)}

\item{lwd.hyb}{Width of hybrid segments with respect to lwd (default: 1)}

\item{col.hyb}{Colour of hybrid segments, when applicable (default: "black")}

\item{plot}{Should a new plotting window be opened first (default: TRUE)}

\item{col}{Colours to use for the \code{k} different clusters (see details). 
Default: \code{col=rainbow})}

\item{axes}{Should the axes be displayed (default: TRUE)}

\item{cex}{Text and symbol magnification (see \link{graphical parameters})
(default: 1)}

\item{lty}{Reference line type (see \link{graphical parameters} for details)}

\item{lwd}{Reference line width (see \link{graphical parameters} for details)}

\item{lwd.pt}{Line width around points with respect to lwd (default: 1)}

\item{invert.axes}{Should axes be inverted on the plot (default: FALSE)}

\item{...}{Other \link{graphical parameters}}
}
\description{
Method \code{plot.constr.hclust} displays the results of space-constrained or
time-constrained agglomerative cluster analyses obtained from multivariate
dissimilarity matrices.
}
\details{
The plotting method uses the coordinates provided by the user of
\code{\link{constr.hclust}} to display the observations. It cuts the tree
(see \link{cutree}) into \code{k} clusters and uses the colours provided as
argument \code{col} to display each cluster. When \code{links = TRUE}, each
edge is displayed as a segments with colours corresponding to the clusters at
its two ends. A special treatment is done for hybrids edges: those whose
ends lie in different clusters; it is controlled by argument \code{hybrids}.
When argument \code{hybrids="change"} (the default), hybrid links are
represented as segments whose colours change halfway. When
\code{hybrids="single"}, hybrid edges are shown as single-color lines,
whose color is given as argument \code{col.hyb}, whereas
\code{hybrids="none"} suppresses the drawing of hybrid edges. Whenever hybrid
edges are displayed, their width with respect to the lwd value is controlled
by argument \code{lwd.hyb}.

When argument \code{plot=FALSE}, no \code{plot} command is issued and the
points (and segments when \code{links = TRUE}) are drawn over an existing
plotting window. This functionality is to allow one to plot the result of a
constrained clustering over an existing map. In that case, arguments
\code{xlim}, \code{ylim}, \code{axes}, and all other
\link{graphical parameters} to which the method \link{plot} would responds are
ignored.

The default colours are generated by function \link{rainbow}; see
\link{palette} for further details on using colour palettes in R. 
The colour palette can be changed by the user.
}
\examples{
##
### Artificial map data from Legendre & Legendre (2012, Fig. 13.26)
### n = 16
##
dat <- c(41,42,25,38,50,30,41,43,43,41,30,50,38,25,42,41)
coord.dat <- matrix(c(1,3,5,7,2,4,6,8,1,3,5,7,2,4,6,8,
                      4.4,4.4,4.4,4.4,3.3,3.3,3.3,3.3,
                      2.2,2.2,2.2,2.2,1.1,1.1,1.1,1.1),16,2)
##
### Obtaining a list of neighbours:
library(spdep)
listW <- nb2listw(tri2nb(coord.dat), style="B")
links.mat.dat <- listw2mat(listW)
neighbors <- listw2sn(listW)[,1:2]
##
### Calculating the (Euclidean) distance between points:
D.dat <- dist(dat)
##
### Display the points:
plot(coord.dat, type='n',asp=1)
title("Delaunay triangulation")
text(coord.dat, labels=as.character(as.matrix(dat)), pos=3)
for(i in 1:nrow(neighbors))
    lines(rbind(coord.dat[neighbors[i,1],],
          coord.dat[neighbors[i,2],]))
##
### Clustering with a contiguity constraint described by a list of
### links:
grpWD2cst_constr_hclust <-
    constr.hclust(
        D.dat, method="ward.D2",
        neighbors, coord.dat)
##
### Plot the results with k=5 clusters on a map:
plot(grpWD2cst_constr_hclust, k=5, links=TRUE, las=1,
     xlab="Eastings", ylab="Northings", pch=21L, cex=3, lwd=3)
##
### Repeat the plot with other values of k (number of groups)

}
\author{
Guillaume Guénard \email{guillaume.guenard@umontreal.ca}
and Pierre Legendre \email{pierre.legendre@umontreal.ca}
}
