% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msr.varipart.R
\name{msr.varipart}
\alias{msr.varipart}
\title{Moran spectral randomization for variation partitioning}
\usage{
\method{msr}{varipart}(x, listwORorthobasis, nrepet = x$test$rep[1],
  method = c("pair", "triplet", "singleton"), ...)
}
\arguments{
\item{x}{An object generated by the \code{varipart} function.}

\item{listwORorthobasis}{an object of the class \code{listw} (spatial weights)
created by the functions of the \pkg{spdep} package or an object of class
\code{orthobasis}}

\item{nrepet}{an \code{integer} indicating the number of replicates}

\item{method}{an character specifying which algorithm should be used to
produce spatial replicates (see code{\link{msr.default}}).}

\item{\dots}{further arguments of the code{\link{msr.default}} function.}
}
\value{
An object of class \code{varipart} randomized replicates.
}
\description{
The functions allows to evaluate the significance and estimate parts in
variation partitioning using Moran Spectral Randomization (MSR) as a
spatially-constrained null model to account for spatial autocorrelation in
table X. Hence, this function provides a variation partioning adujsted for
spurious correlation due to spatial autocorrelation in both the response and
one explanatory matrix.
}
\details{
The function corrects the biases due to spatial autocorrelation by
 using MSR procedure to produce environmental predictors that preserve the
 spatial autocorrelation and the correlation structures of the original
 environmental variables while being generated independently of species
 distribution.
}
\examples{
library(ade4)
library(spdep)
data(mafragh)
## Performing standard variation partitioning
dudiY <- dudi.pca(mafragh$flo, scannf = FALSE, scale = FALSE)
mafragh.lw <- nb2listw(mafragh$nb)
me <- mem(mafragh.lw, MEM.autocor = "positive")
vprda <- varipart(dudiY, mafragh$env, me, type = "parametric")

## Adjust estimation and compute p-value by msr methods
vprda.msr <- msr(vprda, mafragh.lw, nrepet=99)
vprda.msr
}
\references{
Clappe, S., Dray S. and P.R. Peres-Neto (2018) Beyond
neutrality: disentangling the effects of species sorting and spurious
correlations in community analysis. Ecology 99:1737-1747.

Wagner, H. H., and S. Dray (2015). Generating spatially constrained null models
for irregularly spaced data using Moran spectral randomization methods.
Methods in Ecology and Evolution 6:1169-1178.
}
\seealso{
\code{\link{msr.default}}, \code{\link[ade4]{varipart}}
}
\author{
(s) Stephane Dray \email{stephane.dray@univ-lyon1.fr} and Sylvie
Clappe \email{sylvie.clappe@univ-lyon1.fr}
}
