% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.orthobasisSp.R
\name{plot.orthobasisSp}
\alias{plot.orthobasisSp}
\title{Function to display Moran's Eigenvector Maps (MEM) and other spatial 
orthogonal bases}
\usage{
\method{plot}{orthobasisSp}(x, SpORcoords, pos = -1, plot = TRUE,
  match.ID = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{orthobasisSp}}

\item{SpORcoords}{either a \code{Spatial*} object or a \code{matrix} with 
geographic coordinates}

\item{pos}{an integer indicating the position of the environment where the 
data are stored, relative to the environment where the function is called. 
Useful only if \code{storeData} is \code{FALSE}}

\item{plot}{a logical indicating if the graphics is displayed}

\item{match.ID}{a logical indicating if names of geographic entities match 
rownames of the \code{orthobasisSp} object}

\item{\dots}{additional graphical parameters (see \code{\link[adegraphics]{adegpar}} and 
\code{trellis.par.get})}
}
\value{
an object of class \code{ADEgS}, generated by the \code{s.Spatial} 
  function of the \code{adegraphics} package
}
\description{
This function allow to plot or map orthogonal bases
}
\examples{
if(require("ade4", quietly = TRUE) & require("spdep", quietly = TRUE)){
data(mafragh)
me <- mem(nb2listw(mafragh$nb))

if(require("adegraphics", quietly = TRUE)){
plot(me[,1:6], mafragh$xy)
plot(me[,1:6], mafragh$Spatial) 
}
}
        
}
\seealso{
\code{\link[adegraphics]{s.Spatial}}
}
\author{
Stéphane Dray \email{stephane.dray@univ-lyon1.fr}
}
