% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalogram.R
\name{scalogram}
\alias{scalogram}
\alias{plot.scalogram}
\title{Function to compute a scalogram}
\usage{
scalogram(
  x,
  orthobasisSp,
  nblocks = ncol(orthobasisSp),
  nrepet = 999,
  p.adjust.method = "none"
)

\method{plot}{scalogram}(x, pos = -1, plot = TRUE, ...)
}
\arguments{
\item{x}{a numeric vector for univariate data or an object of class \code{dudi} for 
multivariate data (for \code{scalogram}) or an object of class 
 \code{scalogram} (for \code{plot.scalogram})}

\item{orthobasisSp}{an object of class \code{orthobasisSp}}

\item{nblocks}{an integer indicating the number of blocks in the smoothed scalogram}

\item{nrepet}{an integer indicating the number of permutations used in the 
randomization procedure}

\item{p.adjust.method}{a string indicating a method for multiple adjustment, 
see \code{p.adjust.methods} for possible choices.}

\item{pos}{an integer indicating the position of the environment where the 
data are stored, relative to the environment where the function is called. 
Useful only if \code{storeData} is \code{FALSE}}

\item{plot}{a logical indicating if the graphics is displayed}

\item{\dots}{additional graphical parameters (see \code{\link[adegraphics]{adegpar}} and 
\code{trellis.par.get})}
}
\value{
The function \code{scalogram} returns an object of class 
 \code{scalogram}, subclass \code{krandtest}. The \code{plot} function 
 returns an object of class \code{ADEgS}, generated by the functions of the 
 \code{adegraphics} package
}
\description{
The function decomposes the variance of a variable \code{x} on a basis of 
orthogonal vectors. The significance of the associated R-squared values is 
tested by a randomization procedure. A smoothed scalogram is obtained by 
summing the R-squared values into \code{nblocks}.
}
\details{
On the plot, oberved R-squared values are represent by bars. A black line 
indicate the 0.95 quantile of the values obtained by permutations. Significant
values are indicated by a '*'
}
\examples{
if(require("ade4", quietly = TRUE) & require("spdep", quietly = TRUE)){
data(mafragh)
me <- mem(nb2listw(mafragh$nb))

if(require("adegraphics", quietly = TRUE)){
sc1 <- scalogram(mafragh$env$Conduc, me, nblocks = 10)
plot(sc1) 
}
}
 
}
\references{
Dray S., Pélissier R., Couteron P., Fortin M.J., Legendre P., Peres-Neto P.R.,
Bellier E., Bivand R., Blanchet F.G., De Caceres M., Dufour A.B., Heegaard E.,
Jombart T., Munoz F., Oksanen J., Thioulouse J., Wagner H.H. (2012). Community
ecology in the age of multivariate multiscale spatial analysis. 
\emph{Ecological Monographs} \bold{82}, 257--275.
}
\seealso{
\code{\link{mem}} \code{\link[ade4]{orthobasis}}
}
\author{
Stéphane Dray \email{stephane.dray@univ-lyon1.fr}
}
\keyword{spatial}
