% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moran.randtest.R
\name{moran.randtest}
\alias{moran.randtest}
\title{Function to compute Moran's index of spatial autocorrelation}
\usage{
moran.randtest(x, listw, nrepet = 999, ...)
}
\arguments{
\item{x}{a \code{vector}, \code{matrix} or \code{data.frame} with numeric data}

\item{listw}{an object of class \code{listw} created for example by \code{\link[spdep]{nb2listw}}}

\item{nrepet}{an integer indicating the number of permutations used in the 
randomization procedure}

\item{\dots}{other arguments to be passed to the \code{\link[ade4]{as.randtest}} or code{\link[ade4]{as.krandtest}} functions.}
}
\value{
An object of class \code{randtest} (one variable) or \code{krandtest} (several variables)
}
\description{
This function computes Moran's I statistic and provide a testing procedure using random permutations.
It is based on the \code{moran.mc} function of the \code{spdep} package. The \code{moran.randtest}
is slightly different as it allows to consider several variables (\code{x} can have more than one columns)
and its ouputs are objects of class \code{randtest} (one variable) or \code{krandtest} (several variables).
}
\examples{

if(require("ade4", quietly = TRUE)  & require("spdep", quiet = TRUE)){
data(mafragh)
tests <- moran.randtest(mafragh$mil, nb2listw(mafragh$nb))
tests
plot(tests)

}
  
}
\author{
Stéphane Dray \email{stephane.dray@univ-lyon1.fr}
}
\references{
Moran, P. A. P. (1950). Notes on continuous stochastic phenomena. Biometrika, 37, 17–23.
}
\seealso{
\code{\link[spdep]{moran.mc}}
}
\keyword{spatial}

