\name{bullseye}
\alias{bullseye}
\title{Fan-like phylogeny with possible representation of traits on tips}
\description{
  This function represents a phylogeny as a fan, using circles to
  provide a legend for distances and optionally colored symbols to
  represent traits associated to the tips of the tree. This function
  uses and is compatible with ape's \code{\link[ape]{plot.phylo}}.
}
\usage{
bullseye(phy, traits=NULL, col.tips.by=NULL, col.pal=seasun,
         circ.n=6, circ.bg=transp("royalblue",.1), circ.unit=NULL,
         legend=TRUE, leg.posi="bottomleft", leg.title="", leg.bg="white",
         traits.inset=1.1, traits.space=0.05, traits.pch=19, traits.cex=1,
         alpha=1, axis=TRUE,\dots)
}
\arguments{
  \item{phy}{a tree in \code{phylo}, \linkS4class{phylo4} or
    \linkS4class{phylo4d} format.}
  \item{traits}{an optional data.frame of traits.}
  \item{col.tips.by}{an optional vector used to define colors for tip
    labels; if unamed, must be ordered in the same order as
    \code{phy$tip.label}.}
  \item{col.pal}{a function generating colors according to a given
    palette; several palettes can be provided as a list, in the case of
    several traits; the first palette is always reserved for the tip
    colors; this argument is recycled.}
  \item{circ.n}{the number of circles for the distance annotations.}
  \item{circ.bg}{the color of the circles.}
  \item{circ.unit}{the unit of the circles; if NULL, determined
    automatically from the data.}
  \item{legend}{a logical specifying whether a legend should be
    plotted; only one legend is displayed, with priority to tip colors
    first, and then to the first trait.}
  \item{leg.posi,leg.title,leg.bg}{position, title and background for the legend.}
  \item{traits.inset}{inset for positioning the traits; 1 corresponds to
    the circle crossing the furthest tip, 0 to the center of the plot.}
  \item{traits.space}{a coefficient indicating the spacing between traits.}
  \item{traits.pch,traits.cex}{type and size of the symbols used for the
    traits; recycled if needed.}
  \item{alpha}{alpha value to be used for the color transparency,
    between 0 (invisible) and 1 (plain).}
  \item{axis}{a logical indicating whether an axis should be displayed.}
  \item{\dots}{further arguments to be passed to plot methods from
    \code{ape}. See \code{\link[ape]{plot.phylo}}.}
}
\seealso{
  \code{\link{table.phylo4d}} for non-radial plots.\cr

  The \linkS4class{phylo4d} class for storing \code{phylogeny+data}.\cr

  \code{\link[ape]{plot.phylo}} from the \code{ape} package.\cr

  \code{\link[ade4]{dotchart.phylog}}.
}
\author{Thibaut Jombart \email{tjombart@imperial.ac.uk}}
\examples{

data(lizards)
tre <- read.tree(text=lizards$hprA) # make a tree

## basic plots
bullseye(tre)
bullseye(tre, lizards$traits)

## customized
par(mar=c(6,6,6,6))
bullseye(tre, lizards$traits, traits.cex=sqrt(1:7), alpha=.7,
         legend=FALSE, circ.unit=10, circ.bg=transp("black",.1),
         edge.width=2)

}
\keyword{hplot}
\keyword{multivariate}
