% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{matrix.sparse}
\alias{matrix.sparse}
\title{Creates a viewer of a sparse matrix.}
\usage{
matrix.sparse(mat, method = "naive", n_threads = 1)
}
\arguments{
\item{mat}{The sparse matrix to view.}

\item{method}{Method type.}

\item{n_threads}{Number of threads.}
}
\value{
Sparse matrix.
}
\description{
Creates a viewer of a sparse matrix.
}
\examples{
n <- 100
p <- 20
X_dense <- matrix(rnorm(n * p), n, p)
X_sp <- as(X_dense, "dgCMatrix")
out <- matrix.sparse(X_sp, method="naive")
A_dense <- t(X_dense) \%*\% X_dense
A_sp <- as(A_dense, "dgCMatrix")
out <- matrix.sparse(A_sp, method="cov")
}
