% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adea_parametric.R
\name{adea_parametric}
\alias{adea_parametric}
\title{Selection of an optimal subset of variables for DEA analysis}
\usage{
adea_parametric(
  input,
  output,
  orientation = c("input", "output"),
  load.orientation = c("inoutput", "input", "output"),
  name = "",
  direction = c("backward", "backward/input", "backward/output"),
  verbose = 0
)
}
\arguments{
\item{input}{A matrix or a data frame with the inputs of units to be evaluated, one row for each DMU and one column for each input.}

\item{output}{A matrix or a data frame with the outputs of units to be evaluated, one row for each DMU and one column for each output.}

\item{orientation}{Use "input" for input orientation or use "output" for output orientation in DEA model.}

\item{load.orientation}{It allows the selection of variables to be included in load analysis.
Its default value is "inoutput" which means that all input and all output variables will be included. Use "input" or "output" to include only input or output variables in load analysis.}

\item{name}{An optional descriptive name for the model. It will be shown in print and summary results.}

\item{direction}{The direction in which the variables go in and out of the model. Until now, only backward option is implemented.}

\item{verbose}{Use 0 for minimal output, only final model. 1 or more to get detailed information of each step. This option affects only to printed output but not the result.}
}
\value{
A list with all computed models. So, you can retrieve each model individually.
}
\description{
The function returns a list of DEA models removing at least one variable in each step, to get a sequence of models with increasing values of adea loads.
}
\details{
This procedure provides a list of all DEA models for all different threshold for load values.

The models are sorted by increasing values of loads from initially given model to the one with one input and one output variable.
Note that the load value for the model with one input and one output is 1.
In each step at least one variable is dropped, but more than one can be dropped in each step.

See example for more details.
}
\examples{
# Read data
data('cardealers4')
input <- cardealers4[, 1:2]
output <- cardealers4[, 3:4]

# Compute all dea models in parametric way
adea_parametric(input, output)
#        Load #Efficient Factors #Inputs #Outputs                  Inputs              Outputs
# 4 0.6666667          2       4       2        2 Employees, Depreciation CarsSold, WorkOrders
# 3 0.9575672          2       3       1        2            Depreciation CarsSold, WorkOrders
# 2 1.0000000          1       2       1        1            Depreciation             CarsSold

# Compute again and store result in sol.ap
sol.ap <- adea_parametric(input, output)

# Summary the model with 3 variables
summary(sol.ap$models[[3]])
# Model name:
# Orientation is input
# Inputs: Depreciation
# Outputs: CarsSold WorkOrders
# Load: 0.9575672
# Input loads: 1
# Output loads: 1.042433 0.9575672
# Summary of efficiencies:
# Mean        sd      Min.   1st Qu.    Median   3rd Qu.      Max.
# 0.9002232 0.1351949 0.6515044 0.8722527 0.9422250 0.9978982 1.0000000
# Efficiencies:
#  Dealer A  Dealer B  Dealer C  Dealer D  Dealer E  Dealer F 
# 0.9915929 1.0000000 0.8928571 0.8653846 1.0000000 0.6515044

# Get efficiencies for the model with 3 variables
sol.ap$models[[3]]$eff
#  Dealer A  Dealer B  Dealer C  Dealer D  Dealer E  Dealer F
# 0.9915929 1.0000000 0.8928571 0.8653846 1.0000000 0.6515044
}
\seealso{
\code{\link{adea_hierarchical}}
}
