% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelFitFunctions.R
\name{sumCircResids}
\alias{sumCircResids}
\title{Calculate sum of absolute circular residuals}
\usage{
sumCircResids(model)
}
\arguments{
\item{model}{Object of class \code{GCMM} with output from \code{\link{GCMM}} function; residuals must be saved when running the \code{\link{GCMM}} function using \code{saveResids=TRUE}}
}
\value{
Returns list with output summary with mean and 95\% HDI and posterior distribution of summed absolute circular residuals
}
\description{
Calculate posterior probability distribution of summed absolute circular residuals for assessing GCMM model fit
}
\examples{
\donttest{ FoxGCMMresids<-GCMM(data=redfoxsample$Radians, RE1=redfoxsample$SamplingPeriod, saveResids=TRUE,
    scale=c("2pi"), family="vonmises", autorun=FALSE, adapt=0, sample=300, burnin=300, thin=1) 
    FoxResids<-sumCircResids(FoxGCMMresids) }
}
