% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelFitFunctions.R
\name{GCMMppc}
\alias{GCMMppc}
\title{Posterior predictive check of GCMM model}
\usage{
GCMMppc(model, YExp = NULL, clustID = NULL)
}
\arguments{
\item{model}{Object of class \code{GCMM} with output from \code{\link{GCMM}} function; if YExp and clustIDs are not provided as vectors, the GCMM model
must contain this information using the arguments \code{saveYExp=TRUE} and \code{saveclustIDs=TRUE}}

\item{YExp}{Vector of YExp values from GCMM function; see also \code{\link{GCMM}}}

\item{clustID}{Vector of clustID values from GCMM function; see also \code{\link{GCMM}}}
}
\value{
Returns vector of simulated values and prints plot of simulated and raw values
}
\description{
Conduct posterior predictive check (PPC) by simulating data from fitted GCMM model and plotting against observed data
}
\examples{
\donttest{ 
  FoxGCMMPPC<-GCMM(data=redfoxsample$Radians, RE1=redfoxsample$CameraTrapID, family="vonmises", 
    saveclustIDs=TRUE, saveYExp=TRUE,
    scale=c("2pi"), autorun=FALSE, adapt=0, sample=300, burnin=300, thin=1) 
  FoxPPC<-GCMMppc(FoxGCMMPPC)  }
}
