% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity_code_1_1.r
\name{yfromx}
\alias{yfromx}
\title{Impute empirical circular distribution.}
\usage{
yfromx(xvals, x, y)
}
\arguments{
\item{xvals}{Numeric circular values at which to evaluate \code{y}}

\item{x}{Evenly spaced ascending numeric sequence of circular values}

\item{y}{Empirical numeric output distribution matched with \code{x}}
}
\value{
A numeric vector of \code{y} values evaluated at \code{xvals}
}
\description{
Imputes values at given points on an empirical circular distribution.
}
\details{
Note that x is assumed circular, so first and last \code{y} values should be equal. Evaluation points \code{xvals} should also be within the range of \code{x}.
}
\examples{
#Abstract example
x <- seq(0,2*pi,length.out=11)
y <- c(0,1,2,3,4,5,4,3,2,1,0)
yfromx(0:6,x,y)

#BCI data example
#Weighting ocelot activity pattern to correct for variation in speed
data(BCIspeed)
data(BCItime)
#Fit linear-circular model to log(speed)
i <- BCIspeed$species=="ocelot"
lcfit <- fitlincirc(BCIspeed$time[i]*2*pi, log(BCIspeed$speed[i]), reps=50)
#Fit weighted activity model using yfromx to create weights
j <- BCItime$species=="ocelot"
tdat <- BCItime$time[j]*2*pi
w <- 1/yfromx(tdat, lcfit@fit$x, exp(lcfit@fit$fit))
mod <- fitact(tdat, wt=w, sample="none")
plot(mod)
#Oveplot unweighted model for comparison
mod2 <- fitact(tdat, sample="none")
plot(mod2, lcol=3, add=TRUE)
}

