% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timezone.R
\name{localize_to_time_zone}
\alias{localize_to_time_zone}
\title{Uses Google Maps Time Zone APIs to localize the time zone.}
\usage{
localize_to_time_zone(df)
}
\arguments{
\item{df}{A Activatr DF: a tibble from \code{parse_gpx} or \code{parse_tcx}.}
}
\value{
That same Activatr DF, but with the \code{time} column updated to be
        in the local time zone rather than UTC.
}
\description{
This returns a mutated Activatr DF with the time column updated to reflect
the correct time zone, using the Google Maps Time Zone APIs.
}
\details{
Note that to avoid overuse of the API, this does an "approximation", in that
it finds the correct time zone for the first point in the data frame, and
assumes all points in that data frame use that time zone. Runs between time
zones (or runs that cross daylight savings time shifts) will hence be
recorded using a consistent, but not always pointwise correct, timezone.

Note that you must have previously called \code{ggmap::register_google} to
register an API key before calling this.
}
