% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcripts_rename.R
\name{transcripts_rename}
\alias{transcripts_rename}
\title{Rename transcripts in a corpus}
\usage{
transcripts_rename(
  x,
  newTranscriptNames = NULL,
  searchPatterns = NULL,
  searchReplacements = NULL,
  toUpperCase = FALSE,
  toLowerCase = FALSE,
  trim = FALSE,
  stopIfNotUnique = TRUE
)
}
\arguments{
\item{x}{Corpus object}

\item{newTranscriptNames}{Vector of character strings; new names for the transcripts. If left open, the current names in the corpus object will be taken as basis.}

\item{searchPatterns}{Character string; Search pattern as regular expression applied to the names of the transcripts.}

\item{searchReplacements}{Character string; String to replace the hits of the search.}

\item{toUpperCase}{Logical; Convert transcript names all to upper case.}

\item{toLowerCase}{Logical; Convert transcript names all to lower case.}

\item{trim}{Logical; Remove leading and trailing spaces in names.}

\item{stopIfNotUnique}{Logical; If \code{TRUE} the function will stop if replacement would lead to non-unique names; If \code{FALSE} names will be automatically changed to be unique.}
}
\value{
Corpus object
}
\description{
Rename transcript objects in a corpus object.
This function changes both the names of the transcripts in the list \code{x@transcripts} and in the \code{@name} slot of the transcript.
The function ensures that each transcript object preserves a unique name.
}
\examples{
library(act)

# get current names 
old.names <- names(examplecorpus@transcripts)

# make vector of names with the same length
new.names <- paste("transcript", 1:length(old.names), sep="")

# rename the transcripts
test <- act::transcripts_rename(examplecorpus, newTranscriptNames=new.names)

# check
names(test@transcripts)
test@transcripts[[1]]@name
test@history[length(test@history)]

# convert to lower case
test <- act::transcripts_rename(examplecorpus, toLowerCase=TRUE)
test@history[length(test@history)]

# search replace
test <- act::transcripts_rename(examplecorpus, 
 searchPatterns=c("ARG", "BOL"), 
 searchReplacements = c("ARGENTINA", "BOLIVIA")
)
test@history[length(test@history)]

# search replace ignoring upper and lower case
test <- act::transcripts_rename(examplecorpus, 
 searchPatterns=c("(?i)arg", "(?i)bol"), 
 searchReplacements = c("ARGENTINA", "BOLIVIA")
)
test@history[length(test@history)]


# search replace too much
test <- act::transcripts_rename(x=examplecorpus, 
 searchPatterns="ARG_I_CHI_Santi", 
 searchReplacements = "")
names(test@transcripts)[1]

}
