% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations_matrix.R
\name{annotations_matrix}
\alias{annotations_matrix}
\title{Search and replace contents of annotations using a matrix}
\usage{
annotations_matrix(x, path_replacementMatrixCSV, filterTranscriptNames = NULL)
}
\arguments{
\item{x}{Corpus object.}

\item{path_replacementMatrixCSV}{Character string; path to replacement matrix (a CSV file).}

\item{filterTranscriptNames}{Vector of character strings; names of the transcripts to be included.}
}
\value{
Corpus object.
}
\description{
This functions performs a search and replace in the contents of an annotation.
A simple matrix consisting of two columns will be used.
The first column of the matrix needs to contain the search string, the second column  the replacement string.
The matrix needs to be in CSV format.
}
\examples{
library(act)

# An example replacement matrix comes with the package.
# It replaces most of the GAT conventions.
path <- system.file("extdata", "normalization", "normalizationMatrix.csv", package="act")

# Have a look at the matrix
mymatrix <- act::matrix_load(path)
mymatrix

# Apply matrix to examplecorpus
test <- act::annotations_matrix(x=examplecorpus, path_replacementMatrixCSV=path)

# Compare some annotations in the original examplecorpus object and
# in the modified corpus object test
examplecorpus@transcripts[[1]]@annotations$content[[1]]
test@transcripts[[1]]@annotations$content[[1]]

examplecorpus@transcripts[[2]]@annotations$content[[3]]
test@transcripts[[2]]@annotations$content[[3]]
}
\seealso{
\code{\link[=matrix_load]{matrix_load()}} for loading the matrix
and \code{\link[=matrix_save]{matrix_save()}} for saving the matrix to a CSV file.

If only certain transcripts or tiers should be affected set the parameter \code{filterTranscriptNames}.
In case that you want to select transcripts  by using regular expressions use the function \code{act::search_makefilter} first.

\link{media_delete}, \link{media_getPathToExistingFile}
}
