% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concentration_index.R
\name{concentration_index}
\alias{concentration_index}
\title{Concentration Index}
\usage{
concentration_index(
  accessibility_data,
  sociodemographic_data,
  opportunity,
  population,
  income,
  type,
  group_by = character(0)
)
}
\arguments{
\item{accessibility_data}{A data frame. The accessibility levels whose
inequality should be calculated. Must contain the columns \code{id} and any
others specified in \code{opportunity}.}

\item{sociodemographic_data}{A data frame. The distribution of
sociodemographic characteristics of the population in the study area cells.
Must contain the columns \code{id} and any others specified in \code{population} and
\code{income}.}

\item{opportunity}{A string. The name of the column in \code{accessibility_data}
with the accessibility levels to be considerend when calculating inequality
levels.}

\item{population}{A string. The name of the column in \code{sociodemographic_data}
with the number of people in each cell. Used to weigh accessibility levels
when calculating inequality.}

\item{income}{A string. The name of the column in \code{sociodemographic_data}
with the income variable that should be used to sort the population from
the least to the most privileged. Please note that this variable should
describe income per capita (e.g. mean income per capita, household income
per capita, etc), instead of the total amount of income in each cell. Also
note that, while income is generally used to rank population groups, any
variable that can be used to describe one's socioeconomic status, such as
education level, can be passed to this argument, as long as it can be
numerically ordered (in which higher values denote higher socioeconomic
status).}

\item{type}{A string. Which type of Concentration Index to calculate. Current
available options are \code{"standard"} and \code{"corrected"}.}

\item{group_by}{A \code{character} vector. When not \code{character(0)} (the default),
indicates the \code{accessibility_data} columns that should be used to group the
inequality estimates by. For example, if \code{accessibility_data} includes a
\code{scenario} column that identifies distinct scenarios that each
accessibility estimates refer to (e.g. before and after a transport policy
intervention), passing \code{"scenario"} to this parameter results in inequality
estimates grouped by scenario.}
}
\value{
A data frame containing the inequality estimates for the study area.
}
\description{
Calculates the Concentration Index (CI) of a given accessibility
distribution. This measures estimates the extent to which accessibility
inequalities are systematically associated with individuals' socioeconomic
levels. CI values can theoretically vary between -1 and +1 (when all
accessibility is concentrated in the most or in the least disadvantaged
person, respectively). Negative values indicate that inequalities favor the
poor, while positive values indicate a pro-rich bias. The function supports
calculating the standard relative CI and the corrected CI, as proposed by
\insertCite{erreygers2009correcting;textual}{accessibility}.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data_dir <- system.file("extdata", package = "accessibility")
travel_matrix <- readRDS(file.path(data_dir, "travel_matrix.rds"))
land_use_data <- readRDS(file.path(data_dir, "land_use_data.rds"))

access <- cumulative_cutoff(
  travel_matrix,
  land_use_data,
  cutoff = 30,
  opportunity = "jobs",
  travel_cost = "travel_time"
)

ci <- concentration_index(
  access,
  sociodemographic_data = land_use_data,
  opportunity = "jobs",
  population = "population",
  income = "income_per_capita",
  type = "corrected"
)
ci
\dontshow{\}) # examplesIf}
}
\references{
\insertAllCited{}
}
\seealso{
Other inequality: 
\code{\link{gini_index}()},
\code{\link{palma_ratio}()},
\code{\link{theil_t}()}
}
\concept{inequality}
