% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumulative_interval.R
\name{cumulative_time_interval}
\alias{cumulative_time_interval}
\title{Cumulative access based on maximum travel time interval}
\usage{
cumulative_time_interval(
  data,
  interval,
  stat = "mean",
  opportunity_col,
  travel_cost_col = "travel_time",
  by_col
)
}
\arguments{
\item{data}{A \code{data.frame} with a travel cost matrix in long format,
containing the columns with origin ids, destination ids, the travel cost
between each origin-destination pair (this can be either in  terms of
travel time, distance or monetary costs), and number of population and
opportunities located in each origin and destination.}

\item{interval}{An \verb{numeric vector} of length 2, indicating the start and end
points of the interval of travel time thresholds to be used.}

\item{stat}{A \code{string} indicating the summary statistic used to aggregate the
accessibility estimates within the time interval. It accepts either \code{median}
(Default) or \code{mean}.}

\item{opportunity_col}{A \code{string} indicating the name of the column with the
number of opportunities / resources / services to be considered.}

\item{travel_cost_col}{A \code{string} with the name of the column with travel
cost between origins and destinations. It can be either either travel time,
distance or monetary costs. Defaults to \code{travel_ime}.}

\item{by_col}{A \code{string} with the name of the column of origin or
destination that should be considered, indicating whether accessibility
levels should by calculated by each origin (active accessibility) or
destination (passive accessibility).}
}
\value{
A \code{data.table} object.
}
\description{
The function calculates the average or median number of opportunities that
can be reached considering multiple minute-by-minute maximum travel time
thresholds within a given travel time interval specified by the user. The
time interval cumulative accessibility measures was originally proposed by
Tomasiello et al. (\emph{forthcoming}).
}
\details{
\subsection{References:}{
\itemize{
\item Tomasiello, D. B.; Herszenhut, D.; Oliveira, J. L. A.; Braga, C. K. V.;
Pereira, R. H. M. (\emph{forthcoming}). A time interval metric for cumulative
opportunity accessibility.
}
}
}
\examples{
library(accessibility)

# load a travel time matrix data in long format
data_path <- system.file("extdata/ttm_bho.rds", package = "accessibility")
ttm <- readRDS(data_path)

df <- cumulative_time_interval(data = ttm,
                              interval = c(20, 30),
                              stat ='mean',
                              opportunity_col = 'schools',
                              travel_cost_col = 'travel_time',
                              by_col = 'from_id')
head(df)

df <- cumulative_time_interval(data = ttm,
                              interval = c(40, 80),
                              stat ='mean',
                              opportunity_col = 'jobs',
                              travel_cost_col = 'travel_time',
                              by_col = 'from_id')
head(df)

}
\seealso{
Other Cumulative access: 
\code{\link{cumulative_time_cutoff}()}
}
\concept{Cumulative access}
