% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumulative_cutoff.R
\name{cumulative_time_cutoff}
\alias{cumulative_time_cutoff}
\title{Cumulative access based on maximum travel time cutoff}
\usage{
cumulative_time_cutoff(
  data,
  cutoff,
  opportunity_col,
  travel_cost_col = "travel_time",
  by_col
)
}
\arguments{
\item{data}{A \code{data.frame} with a travel cost matrix in long format,
containing the columns with origin ids, destination ids, the travel cost
between each origin-destination pair (this can be either in  terms of
travel time, distance or monetary costs), and number of population and
opportunities located in each origin and destination.}

\item{cutoff}{A \code{numeric} value indicating the maximum travel time considered.}

\item{opportunity_col}{A \code{string} indicating the name of the column with the
number of opportunities / resources / services to be considered.}

\item{travel_cost_col}{A \code{string} with the name of the column with travel
cost between origins and destinations. It can be either either travel time,
distance or monetary costs. Defaults to \code{travel_ime}.}

\item{by_col}{A \code{string} with the name of the column of origin or
destination that should be considered, indicating whether accessibility
levels should by calculated by each origin (active accessibility) or
destination (passive accessibility).}
}
\value{
A \code{data.table} object.
}
\description{
The function calculates the number of opportunities accessible under a given
travel time cutoff specified by the user.
}
\examples{
library(accessibility)

# load a travel time matrix data in long format
data_path <- system.file("extdata/ttm_bho.rds", package = "accessibility")
ttm <- readRDS(data_path)

# Active accessibility: number of schools accessible from each origin
df <- cumulative_time_cutoff(data = ttm,
                            cutoff = 30,
                            opportunity_col = 'schools',
                            travel_cost_col = 'travel_time',
                            by_col = 'from_id')
head(df)

# Passive accessibility: number of people that can reach each destination
df <- cumulative_time_cutoff(data = ttm,
                            cutoff = 30,
                            opportunity_col = 'population',
                            travel_cost_col = 'travel_time',
                            by_col = 'to_id')
head(df)
}
\seealso{
Other Cumulative access: 
\code{\link{cumulative_time_interval}()}
}
\concept{Cumulative access}
