% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movingaves.R
\name{movingaves}
\alias{movingaves}
\title{Moving Averages}
\usage{
movingaves(x, window, integer = FALSE, max = FALSE)
}
\arguments{
\item{x}{Integer or numeric vector.}

\item{window}{Integer value specifying window length.}

\item{integer}{Logical value for whether \code{x} is an integer vector.}

\item{max}{Logical value for whether to return maximum moving average (as 
opposed to vector of moving averages).}
}
\value{
Numeric value or vector depending on \code{max}.
}
\description{
Calculates moving averages or maximum moving average. For optimal speed, use 
\code{integer = TRUE} if \code{x} is an integer vector and 
\code{integer = FALSE} otherwise.
}
\examples{
# Load accelerometer data for first 5 participants in NHANES 2003-2004
data(unidata)

# Get data from ID number 21005
id.part1 <- unidata[unidata[, "seqn"] == 21005, "seqn"]
counts.part1 <- unidata[unidata[, "seqn"] == 21005, "paxinten"]

# Create vector of all 10-minute moving averages
all.movingaves <- movingaves(x = counts.part1, window = 10, integer = TRUE)

# Calculate maximum 10-minute moving average
max.movingave <- movingaves(x = counts.part1, window = 10, integer = TRUE, 
                            max = TRUE)


}
