% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_inference.R
\name{cc_inference}
\alias{cc_inference}
\title{cc_inference}
\usage{
cc_inference(
  mod,
  B = 100,
  alpha_max = 0.5,
  numb_cc = NULL,
  resamp_type = "sign-flip",
  light = FALSE
)
}
\arguments{
\item{mod}{an \code{acca} object.}

\item{B}{(\code{100} by default) number of random sampling}

\item{alpha_max}{stop if p-value > alpha_max (\code{alpha_max=0.5} by default).}

\item{numb_cc}{stop after computing p-values for the first \code{numb_cc} are computed(\code{numb_cc=NULL} - the default - means compute all).}

\item{resamp_type}{\code{"sign-flip"} (by default) or \code{"permutation"}}

\item{light}{If \code{TRUE} the orthogonalization of the residuals of the projection on Z is not performed. For large sample size the two methods tend to overlap.}
}
\value{
It returns an   \code{acca} object (see \code{\link[acca]{cc}}) with p-values for each pair of the \code{numb_cc} components.
}
\description{
For each pairs of components, it computes p-values to test the null hypothesis of no correlation between components. The p-values are computed following the resampling method developed in Winkler, A. M., Renaud, O., Smith, S. M., & Nichols, T. E. (2020). Permutation inference for canonical correlation analysis. NeuroImage, 220, 117065. https://doi.org/10.1016/j.neuroimage.2020.117065.
}
\examples{
set.seed(1)
X=matrix(rnorm(500),100,5)
Y=matrix(rnorm(700),100,7)
Z=matrix(rnorm(200),100,2)
mod=cc(X,Y,Z)
mod

ccbiplot(mod)

mod=cc_inference(mod, B = 100, numb_cc = 3)
mod
}
