% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_wheel.R
\name{prob_wheel}
\alias{prob_wheel}
\title{Plot Probability Wheel}
\usage{
prob_wheel(x, type = "posterior")
}
\arguments{
\item{x}{object of class \code{"ab"}.}

\item{type}{character indicating whether to plot a probability wheel
visualizing the prior probabilities of the hypotheses (i.e., \code{type =
"prior"}) or the posterior probabilities of the hypotheses (i.e.,
\code{type = "posterior"}). The default is \code{"posterior"}.}
}
\description{
Function for visualizing prior and posterior probabilities of the hypotheses
as a probability wheel.
}
\examples{
# synthetic data
data <- list(y1 = 10, n1 = 28, y2 = 14, n2 = 26)

# Bayesian A/B test with default settings
ab <- ab_test(data = data)
print(ab)

# visualize prior probabilities of the hypotheses
prob_wheel(ab, type = "prior")

# visualize posterior probabilities of the hypotheses
prob_wheel(ab, type = "posterior")
}
\author{
Quentin F. Gronau
}
