% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqdata-data.R
\docType{data}
\encoding{UTF-8}
\name{seqdata}
\alias{seqdata}
\title{Synthetic Sequential Data}
\format{A list with 4 elements.}
\usage{
seqdata
}
\description{
This data set contains synthetic sequential A/B data (500 observations in
each of the two groups, where the observations are alternating between
groups). \code{y1} denotes the number of successes for the first group,
\code{n1} denotes the corresponding total number of observations for the
first group. Similarly, \code{y2} denotes the number of successes for the
second group and \code{n2} denotes the corresponding total number of
observations for the second group.
}
\examples{
\donttest{
data(seqdata)

# conduct Bayesian A/B test with default settings
ab <- ab_test(data = seqdata)
print(ab)

# produce sequential plot of posterior probabilities of the hypotheses
plot_sequential(ab, thin = 4)

# example of good width and height values for saving to file
cairo_pdf(file.path(tempdir(), "test_plot.pdf"),
          width = 530 / 72, height = 400 / 72)
plot_sequential(ab)
dev.off()
}
}
\keyword{dataset}
